package com.atlassian.application.host.plugin;

import com.atlassian.application.api.ApplicationKey;
import io.atlassian.fugue.Option;

/**
 * Provides access to {@link com.atlassian.application.host.plugin.PluginApplicationMetaData}.
 *
 * @since v1.0
 */
public interface PluginApplicationMetaDataManager
{
    /**
     * Return all the {@link PluginApplicationMetaData}s installed on the platform.
     *
     * @return all the {@code PluginApplicationMetaData}s installed on the platform.
     */
    Iterable<PluginApplicationMetaData> getApplications();

    /**
     * Return the installed {@link PluginApplicationMetaData} with the passed key.
     * {@link io.atlassian.fugue.Option#none()} is returned to indicate that the {@code PluginApplicationMetaData}
     * is not installed.
     *
     * @param key the key to search for.
     * @return the {@code PluginApplicationMetaData} with the passed key or {@link io.atlassian.fugue.Option#none()}
     * if no such {@code PluginApplicationMetaData} exists.
     */
    Option<PluginApplicationMetaData> getApplication(ApplicationKey key);
}
