package com.atlassian.application.host.i18n;

import java.io.Serializable;

/**
 * Provides a way to do i18n.
 *
 * <p>We can't do this using the {@link com.atlassian.sal.api.message.I18nResolver} from SAL as some hosts
 * (e.g. JIRA) do not have direct access to it.</p>
 *
 * @since 1.0
 */
public interface I18nResolver
{
    /**
     * Turn the passed key into an i18n string for the caller's current language.
     *
     * @param key the key to transform.
     *
     * @return the translated text.
     */
    String getText(String key);

    /**
     * Turn the passed key into an i18n string for the caller's current language.
     *
     * @param key the key to transform.
     * @param args the arguments to use in the i18n transform.
     *
     * @return the translated text.
     */
    String getText(String key, Serializable... args);
}
