package com.atlassian.application.host.events;

import com.atlassian.application.api.ApplicationKey;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Common class for events that happen to an {@code Application}.
 *
 * @since 1.0
 */
public abstract class ApplicationEvent
{
    private final ApplicationKey key;

    ApplicationEvent(final ApplicationKey key)
    {
        this.key = checkNotNull(key, String.format("'key' cannot be null."));
    }

    /**
     * Return the {@link com.atlassian.application.api.ApplicationKey} of the
     * {@link com.atlassian.application.api.Application} the event is associated with.
     *
     * @return the {@link com.atlassian.application.api.ApplicationKey} of the
     * {@link com.atlassian.application.api.Application} the event is associated with.
     */
    public final ApplicationKey getKey()
    {
        return key;
    }

    @Override
    public final boolean equals(final Object o)
    {
        if (this == o)
        {
            return true;
        }
        if (o == null || getClass() != o.getClass())
        {
            return false;
        }

        final ApplicationEvent that = (ApplicationEvent) o;
        return key.equals(that.key);

    }

    @Override
    public final int hashCode()
    {
        return key.hashCode();
    }
}
