/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.application.host.plugin;

import com.atlassian.application.host.plugin.PluginDateTimeUtils;
import com.atlassian.fugue.Option;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.impl.AbstractDelegatingPlugin;
import com.atlassian.plugin.osgi.factory.OsgiPlugin;
import com.google.common.base.Function;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.DateTime;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
@ThreadSafe
final class AmpsBuildDateParser
implements Function<Plugin, Option<DateTime>> {
    private static final Logger log = LoggerFactory.getLogger(AmpsBuildDateParser.class);
    private static final String BUILD_DATE_ATTRIBUTE = "Atlassian-Build-Date";

    AmpsBuildDateParser() {
    }

    public Option<DateTime> apply(@Nullable Plugin plugin) {
        if (plugin == null) {
            return Option.none();
        }
        for (Bundle bundle : AmpsBuildDateParser.getPluginBundle(plugin)) {
            Object value = bundle.getHeaders().get(BUILD_DATE_ATTRIBUTE);
            if (value == null) continue;
            Option<DateTime> buildDate = PluginDateTimeUtils.fromPluginString(value.toString());
            if (buildDate.isEmpty()) {
                log.debug("Plugin with key \"{}\" has invalid Atlassian-Build-Date of \"{}\".", (Object)plugin.getKey(), value);
            }
            return buildDate;
        }
        return Option.none();
    }

    private static Option<Bundle> getPluginBundle(Plugin plugin) {
        if (plugin instanceof OsgiPlugin) {
            return Option.option((Object)((OsgiPlugin)plugin).getBundle());
        }
        if (plugin instanceof AbstractDelegatingPlugin) {
            return AmpsBuildDateParser.getPluginBundle(((AbstractDelegatingPlugin)plugin).getDelegate());
        }
        return Option.none();
    }
}

