/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ant.tasks;

import com.atlassian.ant.tasks.PermissionsUtils;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;

public class CopyWithPerms
extends Copy {
    static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private boolean preservePermissions = true;

    public boolean isPreservePermissions() {
        return this.preservePermissions;
    }

    public void setPreservePermissions(boolean preservePermissions) {
        this.preservePermissions = preservePermissions;
    }

    protected void doFileOperations() {
        int i;
        Enumeration<Object> e;
        if (this.fileCopyMap.size() > 0) {
            this.log("Copying " + this.fileCopyMap.size() + " file" + (this.fileCopyMap.size() == 1 ? "" : "s") + " to " + this.destDir.getAbsolutePath());
            e = this.fileCopyMap.keys();
            while (e.hasMoreElements()) {
                String fromFile = (String)e.nextElement();
                String[] toFiles = (String[])this.fileCopyMap.get(fromFile);
                for (i = 0; i < toFiles.length; ++i) {
                    String toFile = toFiles[i];
                    if (fromFile.equals(toFile)) {
                        this.log("Skipping self-copy of " + fromFile, this.verbosity);
                        continue;
                    }
                    try {
                        this.log("Copying " + fromFile + " to " + toFile, this.verbosity);
                        FilterSetCollection executionFilters = new FilterSetCollection();
                        if (this.filtering) {
                            executionFilters.addFilterSet(this.getProject().getGlobalFilterSet());
                        }
                        Enumeration filterEnum = this.getFilterSets().elements();
                        while (filterEnum.hasMoreElements()) {
                            executionFilters.addFilterSet((FilterSet)filterEnum.nextElement());
                        }
                        this.fileUtils.copyFile(new File(fromFile), new File(toFile), executionFilters, this.getFilterChains(), this.forceOverwrite, this.preserveLastModified, false, this.getEncoding(), this.getOutputEncoding(), this.getProject(), this.getForce());
                        if (!this.preservePermissions) continue;
                        int perms = PermissionsUtils.getPermissions(new File(fromFile));
                        PermissionsUtils.setPermissions(new File(toFile), perms);
                        continue;
                    }
                    catch (IOException ioe) {
                        String msg = "Failed to copy " + fromFile + " to " + toFile + " due to " + this.getDueTo(ioe);
                        File targetFile = new File(toFile);
                        if (targetFile.exists() && !targetFile.delete()) {
                            msg = msg + " and I couldn't delete the corrupt " + toFile;
                        }
                        if (this.failonerror) {
                            throw new BuildException(msg, (Throwable)ioe, this.getLocation());
                        }
                        this.log(msg, 0);
                    }
                }
            }
        }
        if (this.includeEmpty) {
            e = this.dirCopyMap.elements();
            int createCount = 0;
            while (e.hasMoreElements()) {
                String[] dirs = (String[])e.nextElement();
                for (i = 0; i < dirs.length; ++i) {
                    File d = new File(dirs[i]);
                    if (d.exists()) continue;
                    if (!d.mkdirs()) {
                        this.log("Unable to create directory " + d.getAbsolutePath(), 0);
                        continue;
                    }
                    ++createCount;
                }
            }
            if (createCount > 0) {
                this.log("Copied " + this.dirCopyMap.size() + " empty director" + (this.dirCopyMap.size() == 1 ? "y" : "ies") + " to " + createCount + " empty director" + (createCount == 1 ? "y" : "ies") + " under " + this.destDir.getAbsolutePath());
            }
        }
    }

    private String getDueTo(Exception ex) {
        boolean baseIOException = ex.getClass() == IOException.class;
        StringBuffer message = new StringBuffer();
        if (!baseIOException || ex.getMessage() == null) {
            message.append(ex.getClass().getName());
        }
        if (ex.getMessage() != null) {
            if (!baseIOException) {
                message.append(" ");
            }
            message.append(ex.getMessage());
        }
        if (ex.getClass().getName().indexOf("MalformedInput") != -1) {
            message.append(LINE_SEPARATOR);
            message.append("This is normally due to the input file containing invalid");
            message.append(LINE_SEPARATOR);
            message.append("bytes for the character encoding used : ");
            message.append(this.getEncoding() == null ? this.fileUtils.getDefaultEncoding() : this.getEncoding());
            message.append(LINE_SEPARATOR);
        }
        return message.toString();
    }
}

