package com.atlassian.analytics.client.report;

import com.atlassian.analytics.client.TimeKeeper;

public class TimeoutChecker
{
    private static final int DEFAULT_TIMEOUT_MILLIS = 1000 * 60 * 60; // 60 minutes

    private final TimeKeeper timeKeeper;
    private long timeoutMillis;
    private long lastActionTime;

    public TimeoutChecker(final TimeKeeper timeKeeper)
    {
        this.timeKeeper = timeKeeper;
        this.timeoutMillis = DEFAULT_TIMEOUT_MILLIS;
        this.lastActionTime = 0;
    }

    public void setTimeoutMillis(final long timeoutMillis)
    {
        this.timeoutMillis = timeoutMillis;
    }

    public void actionHasOccurred()
    {
        lastActionTime = timeKeeper.currentTimeMillis();
    }

    public boolean isTimeoutExceeded()
    {
        return (timeKeeper.currentTimeMillis() - lastActionTime > timeoutMillis);
    }
}
