package com.atlassian.analytics.client.hash.reader;


import com.google.common.base.Optional;

/**
 * Provides hashing instructions to be used by the {@link com.atlassian.analytics.client.hash.AnalyticsEmailHasher}
 */
public interface HashingInstructionsReader {
    /**
     * Given a unique identifier for the hashing instructions we want to retrieve, this returns an optional
     * set of instructions. The instructions could be empty if there was an error retrieving them.
     *
     * @param instructionsKey unique identifier for the hashing instructions
     * @return hashing instructions
     */
    Optional<String> readInstructions(String instructionsKey);
}
