package com.atlassian.analytics.client.filter;

import com.atlassian.analytics.client.sen.SenProvider;

import org.apache.commons.lang.StringUtils;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * Add the instance SEN to all response headers. This will allow it show up in the OD proxy access logs, so
 * we can tie each log line to a specific instance for analysis/debugging purposes.
 */
public class DefaultAnalyticsFilter extends AbstractHttpFilter
{
    private static final String X_SEN_HEADER = "X-ASEN";

    private final SenProvider senProvider;

    public DefaultAnalyticsFilter(final SenProvider senProvider)
    {
        this.senProvider = senProvider;
    }

    @Override
    protected void doFilter(final HttpServletRequest request, final HttpServletResponse response, final FilterChain filterChain) throws IOException, ServletException
    {
        String sen = senProvider.getSen();
        if (StringUtils.isNotBlank(sen))
        {
            response.setHeader(X_SEN_HEADER, sen);
            setB3TraceId(request);
        }

        filterChain.doFilter(request, response);
    }
}
