package com.atlassian.analytics.client.eventfilter;

import java.util.regex.Pattern;

/**
 * Filter that checks if the string (the attribute value) is allowed, even if not whitelisted explicitly;
 */
public class AllowedWordFilter
{
    private static final Pattern UUID_PATTERN = Pattern.compile("(?i)[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("[0-9.,_%\\-]+");

    public String processAllowedWords(final String propertyValue)
    {
        if (NUMBER_PATTERN.matcher(propertyValue).matches())
        {
            return propertyValue;
        }

        if (UUID_PATTERN.matcher(propertyValue).matches())
        {
            return propertyValue;
        }

        return "";
    }
}
