package com.atlassian.analytics.client;

import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;

import javax.servlet.http.HttpServletRequest;

public class UserPermissionsHelper
{
    private final UserManager userManager;

    public UserPermissionsHelper(final UserManager userManager)
    {
        this.userManager = userManager;
    }

    public boolean isRequestUserSystemAdmin(final HttpServletRequest request)
    {
        return isUserSystemAdmin(userManager.getRemoteUserKey(request));
    }

    public boolean isCurrentUserSystemAdmin()
    {
        return isUserSystemAdmin(userManager.getRemoteUserKey());
    }

    public boolean isUserSystemAdmin(final UserKey userKey)
    {
        return userManager.isSystemAdmin(userKey);
    }

}
