package com.atlassian.analytics.client;

import com.atlassian.sal.api.auth.LoginUriProvider;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;

/**
 * Redirects a request to the login page for the product.
 */
public class LoginPageRedirector
{
    private static final String JIRA_SERAPH_SECURITY_ORIGINAL_URL = "os_security_originalurl";
    private static final String CONF_SERAPH_SECURITY_ORIGINAL_URL = "seraph_originalurl";

    private final LoginUriProvider loginUriProvider;

    public LoginPageRedirector(final LoginUriProvider loginUriProvider)
    {
        this.loginUriProvider = loginUriProvider;
    }

    /**
     * Copied from com.atlassian.upm.PluginManagerHandler.
     */
    public void redirectToLogin(final HttpServletRequest request, final HttpServletResponse response) throws IOException
    {
        final URI uri = getUri(request);
        addSessionAttributes(request, uri.toASCIIString());
        response.sendRedirect(loginUriProvider.getLoginUri(uri).toASCIIString());
    }

    private URI getUri(final HttpServletRequest request)
    {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null)
        {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    private void addSessionAttributes(final HttpServletRequest request, final String uriString)
    {
        request.getSession().setAttribute(JIRA_SERAPH_SECURITY_ORIGINAL_URL, uriString);
        request.getSession().setAttribute(CONF_SERAPH_SECURITY_ORIGINAL_URL, uriString);
    }
}
