package com.atlassian.analytics.api.services;

import java.util.Date;

/**
 * <p>Services related to Atlassian Analytics log uploading.</p>
 *
 * @since v3.69
 */
public interface AnalyticsUploadService {

    /**
     * Returns the last successful analytics upload date.
     */
    Date getLastUploadDate();

    /**
     * @param numberOfDays the number of days the caller is asking about
     * @return whether analytics has been uploaded since x days
     */
    boolean hasUploadedAnalyticsSince(int numberOfDays);
}
