/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen;

import com.atlassian.plugins.codegen.I18nString;
import com.atlassian.plugins.codegen.PluginProjectChangeset;
import com.atlassian.plugins.codegen.ProjectRewriter;
import com.atlassian.plugins.codegen.ResourceFile;
import com.atlassian.plugins.codegen.SourceFile;
import com.atlassian.plugins.codegen.modules.PluginModuleLocation;
import com.atlassian.plugins.codegen.util.FileUtil;
import com.atlassian.plugins.codegen.util.PluginXmlHelper;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.dom4j.DocumentException;

public class ProjectFilesRewriter
implements ProjectRewriter {
    private final PluginModuleLocation location;

    public ProjectFilesRewriter(PluginModuleLocation location) {
        this.location = (PluginModuleLocation)Preconditions.checkNotNull((Object)location, (Object)"location");
    }

    public void applyChanges(PluginProjectChangeset changes) throws Exception {
        this.createSourceFiles(changes);
        this.createResourceFiles(changes);
        if (changes.hasItems(I18nString.class)) {
            this.addI18nStrings(changes.getItems(I18nString.class));
        }
    }

    private void createSourceFiles(PluginProjectChangeset changes) throws IOException {
        for (SourceFile sourceFile : changes.getItems(SourceFile.class)) {
            File baseDir = sourceFile.getSourceGroup() == SourceFile.SourceGroup.TESTS ? this.location.getTestDirectory() : this.location.getSourceDirectory();
            File newFile = FileUtil.dotDelimitedFilePath(baseDir, sourceFile.getClassId().getFullName(), ".java");
            Files.createParentDirs((File)newFile);
            FileUtils.writeStringToFile((File)newFile, (String)sourceFile.getContent(), (Charset)StandardCharsets.UTF_8);
        }
    }

    private void createResourceFiles(PluginProjectChangeset changes) throws IOException {
        for (ResourceFile resourceFile : changes.getItems(ResourceFile.class)) {
            File resourceDir = this.location.getResourcesDir();
            if (!resourceFile.getRelativePath().isEmpty()) {
                resourceDir = new File(resourceDir, resourceFile.getRelativePath());
            }
            File newFile = new File(resourceDir, resourceFile.getName());
            Files.createParentDirs((File)newFile);
            FileUtils.writeByteArrayToFile((File)newFile, (byte[])resourceFile.getContent());
        }
    }

    private void addI18nStrings(Iterable<I18nString> i18nStrings) throws IOException, DocumentException {
        File propertiesFile = this.getI18nFile();
        String oldContent = propertiesFile.exists() ? FileUtils.readFileToString((File)propertiesFile, (Charset)StandardCharsets.UTF_8) : "";
        Properties oldProps = new Properties();
        oldProps.load(new StringReader(oldContent));
        StringBuilder newContent = new StringBuilder(oldContent);
        boolean modified = false;
        for (I18nString item : i18nStrings) {
            if (oldProps.containsKey(item.getName())) continue;
            if (!modified) {
                newContent.append("\n");
            }
            modified = true;
            newContent.append(item.getName()).append("=").append(item.getValue()).append("\n");
            oldProps.put(item.getName(), item.getValue());
        }
        if (modified) {
            FileUtils.writeStringToFile((File)propertiesFile, (String)newContent.toString(), (Charset)StandardCharsets.UTF_8);
        }
    }

    @Nonnull
    private File getI18nFile() throws IOException, DocumentException {
        String defaultI18nLocation = new PluginXmlHelper(this.location).getDefaultI18nLocation();
        File propertiesFile = FileUtil.dotDelimitedFilePath(this.location.getResourcesDir(), defaultI18nLocation, ".properties");
        Files.createParentDirs((File)propertiesFile);
        return propertiesFile;
    }
}

