package com.atlassian.plugins.codegen.modules.jira;

import com.atlassian.plugins.codegen.PluginProjectChangeset;
import com.atlassian.plugins.codegen.annotations.JiraPluginModuleCreator;
import com.atlassian.plugins.codegen.modules.AbstractPluginModuleCreator;

import static com.atlassian.plugins.codegen.modules.Dependencies.MOCKITO_TEST;
import static com.atlassian.plugins.codegen.modules.Dependencies.SLF4J;

/**
 * @since 3.6
 */
@JiraPluginModuleCreator
public class JqlFunctionModuleCreator extends AbstractPluginModuleCreator<JqlFunctionProperties> {

    public static final String MODULE_NAME = "JQL Function";
    private static final String TEMPLATE_PREFIX = "templates/jira/jql/";

    //stub
    private static final String CLASS_TEMPLATE = TEMPLATE_PREFIX + "JqlFunction.java.vtl";
    private static final String UNIT_TEST_TEMPLATE = TEMPLATE_PREFIX + "JqlFunctionTest.java.vtl";

    //examples
    private static final String EXAMPLE_CLASS_TEMPLATE = TEMPLATE_PREFIX + "Example" + CLASS_TEMPLATE;

    private static final String PLUGIN_MODULE_TEMPLATE = TEMPLATE_PREFIX + "jql-function-plugin.xml.vtl";

    @Override
    public PluginProjectChangeset createModule(JqlFunctionProperties props) throws Exception {
        PluginProjectChangeset ret = new PluginProjectChangeset()
                .with(SLF4J,
                        MOCKITO_TEST)
                .with(createModule(props, PLUGIN_MODULE_TEMPLATE));

        if (props.includeExamples()) {
            return ret.with(createClass(props, EXAMPLE_CLASS_TEMPLATE));
        } else {
            return ret.with(createClassAndTests(props, CLASS_TEMPLATE, UNIT_TEST_TEMPLATE));
        }
    }

    @Override
    public String getModuleName() {
        return MODULE_NAME;
    }
}
