/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen.modules.stash.hook;

import com.atlassian.plugins.codegen.PluginProjectChange;
import com.atlassian.plugins.codegen.PluginProjectChangeset;
import com.atlassian.plugins.codegen.ResourceFile;
import com.atlassian.plugins.codegen.annotations.StashPluginModuleCreator;
import com.atlassian.plugins.codegen.modules.AbstractPluginModuleCreator;
import com.atlassian.plugins.codegen.modules.Dependencies;
import com.atlassian.plugins.codegen.modules.stash.hook.RepositoryHookProperties;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

@StashPluginModuleCreator
public class RepositoryHookModuleCreator
extends AbstractPluginModuleCreator<RepositoryHookProperties> {
    public static final String MODULE_NAME = "Repository Hook";
    private static final String TEMPLATE_PREFIX = "templates/stash/repository-hook/";
    private static final String PRE_RECEIVE_TEMPLATE = "templates/stash/repository-hook/PreReceiveRepositoryHook.java.vtl";
    private static final String ASYNC_POST_RECEIVE_TEMPLATE = "templates/stash/repository-hook/AsyncPostReceiveRepositoryHook.java.vtl";
    private static final String MERGE_CHECK_TEMPLATE = "templates/stash/repository-hook/MergeCheckRepositoryHook.java.vtl";
    private static final String PLUGIN_MODULE_TEMPLATE = "templates/stash/repository-hook/repository-hook-plugin.xml.vtl";
    private static final String SOY_TEMPLATE = "templates/stash/repository-hook/repository-hook.soy.vtl";
    public static final String TYPE_PRE = "pre";
    public static final String TYPE_POST = "post";
    public static final String TYPE_MERGE_CHECK = "merge";
    public static final String TYPE_DEFAULT = "post";
    public static final Map<String, String> DEFAULT_CLASS_NAME_BY_TYPE = ImmutableMap.builder().put((Object)"pre", (Object)"MyPreReceiveRepositoryHook").put((Object)"post", (Object)"MyPostReceiveRepositoryHook").put((Object)"merge", (Object)"MyMergeCheckHook").build();
    public static final List<String> TYPES = ImmutableList.copyOf(DEFAULT_CLASS_NAME_BY_TYPE.keySet());

    @Override
    public PluginProjectChangeset createModule(RepositoryHookProperties props) throws Exception {
        PluginProjectChangeset hookClass = this.createClass(props, props.getClassId(), this.getTemplate(props.getType()));
        PluginProjectChangeset changeset = new PluginProjectChangeset().with(new PluginProjectChange[]{Dependencies.MOCKITO_TEST}).with(this.createModule(props, PLUGIN_MODULE_TEMPLATE)).with(hookClass);
        if (props.getIcon() != null) {
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(TEMPLATE_PREFIX + props.getIcon());
            changeset = changeset.with(PluginProjectChangeset.changeset().with(new PluginProjectChange[]{ResourceFile.resourceFile((String)"", (String)props.getIcon(), (byte[])IOUtils.toByteArray((InputStream)in))}));
        }
        if (props.ifConfigured()) {
            changeset = changeset.with(this.createResource(props, "static", props.getSoyFile(), SOY_TEMPLATE));
        }
        return changeset;
    }

    private String getTemplate(String type) {
        String template;
        if (TYPE_PRE.equals(type)) {
            template = PRE_RECEIVE_TEMPLATE;
        } else if ("post".equals(type)) {
            template = ASYNC_POST_RECEIVE_TEMPLATE;
        } else if (TYPE_MERGE_CHECK.equals(type)) {
            template = MERGE_CHECK_TEMPLATE;
        } else {
            throw new RuntimeException("Unsupported type: " + type);
        }
        return template;
    }

    public String getModuleName() {
        return MODULE_NAME;
    }
}

