/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen.util;

import com.atlassian.plugins.codegen.modules.BasicClassModuleProperties;
import com.atlassian.plugins.codegen.modules.ClassBasedModuleProperties;
import com.atlassian.plugins.codegen.modules.PluginModuleProperties;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public class CodeTemplateHelper {
    private static Logger LOG = Logger.getLogger(CodeTemplateHelper.class);
    public static final String UTF8 = "UTF-8";

    public String parseTemplate(String templatePath, Map<Object, Object> props) throws Exception {
        VelocityContext ctx = new VelocityContext();
        ctx.put("parseCheck", (Object)new TemplateChecker());
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            ctx.put(entry.getKey().toString(), entry.getValue());
        }
        StringWriter stringWriter = new StringWriter();
        Template template = Velocity.getTemplate((String)templatePath);
        template.merge((Context)ctx, (Writer)stringWriter);
        return stringWriter.toString();
    }

    public void writeJavaClassFromTemplate(String templatePath, String className, File sourceDirectory, String packageName, ClassBasedModuleProperties props) throws Exception {
        String originalClass = props.getFullyQualifiedClassname();
        BasicClassModuleProperties overrideProps = new BasicClassModuleProperties(originalClass);
        overrideProps.putAll((Map)props);
        overrideProps.setProperty("CLASSNAME", className);
        overrideProps.setProperty("PACKAGE", packageName);
        String content = this.parseTemplate(templatePath, overrideProps);
        String packagePath = packageName.length() == 0 ? "" : packageName.replaceAll("\\.", Matcher.quoteReplacement(File.separator));
        File packageFile = sourceDirectory;
        if (!packagePath.equals("")) {
            packageFile = new File(sourceDirectory, packagePath);
        }
        packageFile.mkdirs();
        File javaFile = new File(packageFile, className + ".java");
        FileUtils.writeStringToFile((File)javaFile, (String)content, (String)UTF8);
    }

    public void writeFileFromTemplate(String templatePath, String fileName, File directory, PluginModuleProperties props) throws Exception {
        String content = this.parseTemplate(templatePath, (Map<Object, Object>)props);
        File newFile = new File(directory, fileName);
        FileUtils.writeStringToFile((File)newFile, (String)content, (String)UTF8);
    }

    public String getStringFromTemplate(String templatePath, PluginModuleProperties props) throws Exception {
        return this.parseTemplate(templatePath, (Map<Object, Object>)props);
    }

    static {
        Velocity.setProperty((String)"input.encoding", (Object)UTF8);
        Velocity.setProperty((String)"parser.pool.size", (Object)3);
        Velocity.setProperty((String)"resource.loader", (Object)"classpath");
        Velocity.setProperty((String)"classpath.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        Velocity.setProperty((String)"velocimacro.library", (Object)"templates/macros.vm");
        try {
            Velocity.init();
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to init velocity", (Throwable)e);
        }
    }

    public class TemplateChecker {
        public synchronized boolean templateExists(String templatePath) {
            System.out.println("templatePath = " + templatePath);
            URL resourceUrl = ClasspathResourceLoader.class.getResource(templatePath);
            return resourceUrl != null;
        }
    }
}

