/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen.modules.jira;

import com.atlassian.plugins.codegen.annotations.Dependencies;
import com.atlassian.plugins.codegen.annotations.Dependency;
import com.atlassian.plugins.codegen.annotations.JiraPluginModuleCreator;
import com.atlassian.plugins.codegen.modules.AbstractPluginModuleCreator;
import com.atlassian.plugins.codegen.modules.PluginModuleLocation;
import com.atlassian.plugins.codegen.modules.jira.WorkflowPostFunctionProperties;
import java.io.File;

@JiraPluginModuleCreator
@Dependencies(value={@Dependency(groupId="org.mockito", artifactId="mockito-all", version="1.8.5", scope="test")})
public class WorkflowPostFunctionModuleCreator
extends AbstractPluginModuleCreator<WorkflowPostFunctionProperties> {
    public static final String MODULE_NAME = "Workflow Post Function";
    private static final String TEMPLATE_PREFIX = "templates/jira/workflow/function/";
    private static final String CLASS_TEMPLATE = "templates/jira/workflow/function/PostFunction.java.vtl";
    private static final String FACTORY_TEMPLATE = "templates/jira/workflow/function/PostFunctionFactory.java.vtl";
    private static final String UNIT_TEST_TEMPLATE = "templates/jira/workflow/function/PostFunctionTest.java.vtl";
    private static final String VIEW_TEMPLATE = "templates/jira/workflow/function/post-function.vm.vtl";
    private static final String INPUT_TEMPLATE = "templates/jira/workflow/function/post-function-input.vm.vtl";
    private static final String PLUGIN_MODULE_TEMPLATE = "templates/jira/workflow/function/post-function-plugin.xml.vtl";

    @Override
    public void createModule(PluginModuleLocation location, WorkflowPostFunctionProperties props) throws Exception {
        String moduleKey = props.getModuleKey();
        String viewFileName = moduleKey + ".vm";
        String inputFileName = moduleKey + "-input.vm";
        String packageName = props.getPackage();
        String functionClass = props.getClassname();
        String factoryClass = props.getFactoryName();
        File templatesDir = new File(location.getTemplateDirectory(), "postfunctions");
        this.templateHelper.writeJavaClassFromTemplate(CLASS_TEMPLATE, functionClass, location.getSourceDirectory(), packageName, props);
        this.templateHelper.writeJavaClassFromTemplate(FACTORY_TEMPLATE, factoryClass, location.getSourceDirectory(), packageName, props);
        this.templateHelper.writeJavaClassFromTemplate(UNIT_TEST_TEMPLATE, this.testClassname(functionClass), location.getTestDirectory(), packageName, props);
        this.templateHelper.writeFileFromTemplate(VIEW_TEMPLATE, viewFileName, templatesDir, props);
        this.templateHelper.writeFileFromTemplate(INPUT_TEMPLATE, inputFileName, templatesDir, props);
        this.addModuleToPluginXml(PLUGIN_MODULE_TEMPLATE, location, props);
    }

    public String getModuleName() {
        return MODULE_NAME;
    }
}

