/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen.modules;

import com.atlassian.plugins.codegen.modules.AbstractPluginModuleProperties;
import com.atlassian.plugins.codegen.modules.NameBasedModuleProperties;
import com.atlassian.plugins.codegen.util.ClassnameUtil;
import com.google.common.collect.ImmutableMap;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractNameBasedModuleProperties
extends AbstractPluginModuleProperties
implements NameBasedModuleProperties {
    protected AbstractNameBasedModuleProperties() {
    }

    public void setModuleNameAndKey(String moduleName) {
        if (StringUtils.isNotBlank((String)moduleName)) {
            this.setModuleName(moduleName);
            this.setModuleKey(ClassnameUtil.camelCaseOrSpaceToDashed(moduleName).toLowerCase());
            this.setDescription("The " + this.getProperty("MODULE_NAME") + " Plugin");
            this.setNameI18nKey(this.getProperty("MODULE_KEY") + ".name");
            this.setDescriptionI18nKey(this.getProperty("MODULE_KEY") + ".description");
        }
    }

    public void setModuleName(String name) {
        this.setProperty("MODULE_NAME", name);
    }

    public String getModuleName() {
        return this.getProperty("MODULE_NAME");
    }

    public void setModuleKey(String name) {
        this.setProperty("MODULE_KEY", name);
    }

    public String getModuleKey() {
        return this.getProperty("MODULE_KEY");
    }

    public void setDescription(String desc) {
        this.setProperty("DESCRIPTION", desc);
    }

    public String getDescription() {
        return this.getProperty("DESCRIPTION");
    }

    public void setDescriptionI18nKey(String key) {
        this.setProperty("DESCRIPTION_I18N_KEY", key);
    }

    public String getDescriptionI18nKey() {
        return this.getProperty("DESCRIPTION_I18N_KEY");
    }

    public void setNameI18nKey(String key) {
        this.setProperty("NAME_I18N_KEY", key);
    }

    public String getNameI18nKey() {
        return this.getProperty("NAME_I18N_KEY");
    }

    @Override
    public ImmutableMap<String, String> getI18nProperties() {
        ImmutableMap.Builder ret = ImmutableMap.builder();
        ret.putAll(super.getI18nProperties());
        if (this.getNameI18nKey() != null) {
            ret.put((Object)this.getNameI18nKey(), (Object)(this.getModuleName() == null ? "" : this.getModuleName()));
        }
        if (this.getDescriptionI18nKey() != null) {
            ret.put((Object)this.getDescriptionI18nKey(), (Object)(this.getDescription() == null ? "" : this.getDescription()));
        }
        return ret.build();
    }
}

