/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.signing.tool;

import com.atlassian.upm.signing.tool.UpmConfigWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public enum UpmConfigShutdownAction {
    DELETE(UpmConfigWriter::deleteConfiguration, "Deleting UMP signature check configuration ...", "Failed to delete UMP signature check configuration", new String[0]),
    MAKE_WRITABLE(UpmConfigWriter::makeConfigWritable, "Making UPM signature check configuration writable...", "Failed to make UMP signature check configuration writable", "writable");

    private final List<String> aliases;
    private final String message;
    private final String failureMessage;
    private final Consumer<UpmConfigWriter> action;

    private UpmConfigShutdownAction(Consumer<UpmConfigWriter> action, String message, String failureMessage, String ... aliases) {
        this.message = message;
        this.action = action;
        this.failureMessage = failureMessage;
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.name().toLowerCase());
        if (aliases != null) {
            for (String alias : aliases) {
                list.add(alias.toLowerCase());
            }
        }
        this.aliases = Collections.unmodifiableList(list);
    }

    public static UpmConfigShutdownAction resolve(String action) {
        return Arrays.stream(UpmConfigShutdownAction.values()).filter(v -> v.aliases.contains(action.toLowerCase())).findFirst().orElse(null);
    }

    public String getMessage() {
        return this.message;
    }

    public void perform(UpmConfigWriter writer) {
        this.action.accept(writer);
    }

    public String getFailureMessage(String details) {
        return this.failureMessage + " : " + details;
    }
}

