/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.signing.tool;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Properties;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtils.class);

    private FileUtils() {
    }

    static void delete(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        if (Files.isRegularFile(path, new LinkOption[0])) {
            try {
                Files.delete(path);
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (Stream<Path> paths = Files.walk(path, 3, new FileVisitOption[0]);){
                paths.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
        }
    }

    static boolean changeWritePermissions(Path path, boolean writable) {
        if (Files.isRegularFile(path, new LinkOption[0])) {
            return path.toFile().setWritable(writable);
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            boolean bl;
            block10: {
                Stream<Path> paths = Files.walk(path, 3, new FileVisitOption[0]);
                try {
                    bl = paths.map(Path::toFile).allMatch(f -> f.setWritable(writable));
                    if (paths == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (paths != null) {
                            try {
                                paths.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        throw new UncheckedIOException(ioe);
                    }
                }
                paths.close();
            }
            return bl;
        }
        return true;
    }

    static boolean write(Path target, String value) {
        if (value == null) {
            return true;
        }
        try {
            Files.deleteIfExists(target);
            Path file = Files.createFile(target, new FileAttribute[0]);
            Files.write(file, value.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            return true;
        }
        catch (IOException ioe) {
            LOGGER.error("Error writing to {}", (Object)target, (Object)ioe);
            return false;
        }
    }

    static boolean isReadable(Path path) {
        return path != null && Files.isRegularFile(path, new LinkOption[0]) && Files.isReadable(path);
    }

    static String readString(Path path) throws IOException {
        return FileUtils.isReadable(path) ? new String(Files.readAllBytes(path), StandardCharsets.UTF_8) : null;
    }

    public static Properties loadProperties(Path configFile) {
        Properties properties = new Properties();
        if (Files.isRegularFile(configFile, new LinkOption[0])) {
            try (InputStream in = Files.newInputStream(configFile, new OpenOption[0]);){
                properties.load(in);
            }
            catch (IOException ioe) {
                LOGGER.warn("Failed to read properties from {}", (Object)configFile);
            }
        }
        return properties;
    }
}

