/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen;

import com.atlassian.plugins.codegen.PluginProjectChange;
import com.atlassian.plugins.codegen.SummarizeAsGroup;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class PluginProjectChangeset {
    private final List<PluginProjectChange> changes = new ArrayList<PluginProjectChange>();
    private static final Predicate<PluginProjectChange> summarizable = input -> input instanceof SummarizeAsGroup;
    private static final Function<PluginProjectChange, String> summarizableGroupName = input -> input instanceof SummarizeAsGroup ? ((SummarizeAsGroup)((Object)input)).getGroupName() : "";
    private static final Function<Map.Entry<String, Collection<PluginProjectChange>>, String> summaryDescription = input -> ((String)input.getKey()).isEmpty() ? null : (String)input.getKey() + ": " + ((Collection)input.getValue()).size();

    public static PluginProjectChangeset changeset() {
        return new PluginProjectChangeset();
    }

    public Iterable<PluginProjectChange> getItems() {
        return ImmutableList.copyOf(this.changes);
    }

    public <T extends PluginProjectChange> Iterable<T> getItems(Class<T> itemClass) {
        return Iterables.filter(this.changes, itemClass);
    }

    public boolean hasItems(Class<? extends PluginProjectChange> itemClass) {
        return !Iterables.isEmpty(this.getItems(itemClass));
    }

    public PluginProjectChangeset with(PluginProjectChange ... newChanges) {
        this.changes.addAll(Arrays.asList(newChanges));
        return this;
    }

    public PluginProjectChangeset with(Iterable<? extends PluginProjectChange> newChanges) {
        newChanges.forEach(this.changes::add);
        return this;
    }

    public PluginProjectChangeset with(PluginProjectChangeset other) {
        this.changes.addAll(other.changes);
        return this;
    }

    public Iterable<String> getAllChangeDescriptions() {
        return Iterables.transform(this.changes, (Function)Functions.toStringFunction());
    }

    public Iterable<String> getChangeDescriptionsOrSummaries() {
        ImmutableSet uniqueDescriptions = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)Iterables.filter(this.changes, (Predicate)Predicates.not(summarizable)), (Function)Functions.toStringFunction()));
        ImmutableListMultimap summaries = Multimaps.index(this.changes, summarizableGroupName);
        return Iterables.concat((Iterable)Ordering.natural().sortedCopy((Iterable)uniqueDescriptions), (Iterable)Iterables.filter((Iterable)Iterables.transform(summaries.asMap().entrySet(), summaryDescription), (Predicate)Predicates.notNull()));
    }

    public String toString() {
        return Joiner.on((String)",\n").join(this.getAllChangeDescriptions());
    }
}

