/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.model.synd;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.wink.common.model.synd.SyndBase;
import org.apache.wink.common.model.synd.SyndEntry;
import org.apache.wink.common.model.synd.SyndGenerator;
import org.apache.wink.common.model.synd.SyndText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyndFeed
extends SyndBase {
    private SyndText subtitle;
    private SyndGenerator generator;
    private String icon;
    private String logo;
    private SyndText rights;
    private List<SyndEntry> entries;
    private long totalResults = -1L;
    private long startIndex = -1L;
    private long itemsPerPage = -1L;

    public SyndFeed() {
    }

    public SyndFeed(String title, String id) {
        this(title, id, null);
    }

    public SyndFeed(SyndText title, String id) {
        this(title, id, null);
    }

    public SyndFeed(String title, String id, Date updated) {
        this(new SyndText(title), id, updated);
    }

    public SyndFeed(SyndText title, String id, Date updated) {
        super(id, title, updated);
    }

    public SyndFeed(SyndFeed other) {
        super(other);
        this.icon = other.icon;
        this.logo = other.logo;
        this.totalResults = other.totalResults;
        this.startIndex = other.startIndex;
        this.itemsPerPage = other.itemsPerPage;
        this.subtitle = new SyndText(other.subtitle);
        this.rights = new SyndText(other.rights);
        this.generator = new SyndGenerator(other.generator);
        this.copyEntries(other.entries);
    }

    private void copyEntries(List<SyndEntry> entries) {
        this.entries = new ArrayList<SyndEntry>();
        for (SyndEntry value : entries) {
            this.entries.add(new SyndEntry(value));
        }
    }

    public SyndText getSubtitle() {
        return this.subtitle;
    }

    public void setSubtitle(SyndText subtitle) {
        this.subtitle = subtitle;
    }

    public SyndGenerator getGenerator() {
        return this.generator;
    }

    public void setGenerator(SyndGenerator generator) {
        this.generator = generator;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public SyndText getRights() {
        return this.rights;
    }

    public void setRights(SyndText rights) {
        this.rights = rights;
    }

    public long getTotalResults() {
        return this.totalResults;
    }

    public void setTotalResults(long totalResults) {
        this.totalResults = totalResults;
    }

    public long getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(long startIndex) {
        this.startIndex = startIndex;
    }

    public long getItemsPerPage() {
        return this.itemsPerPage;
    }

    public void setItemsPerPage(long itemsPerPage) {
        this.itemsPerPage = itemsPerPage;
    }

    public void addEntry(SyndEntry entry) {
        this.getEntries().add(entry);
    }

    public List<SyndEntry> getEntries() {
        if (this.entries == null) {
            this.entries = new ArrayList<SyndEntry>();
        }
        return this.entries;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.entries == null ? 0 : ((Object)this.entries).hashCode());
        result = 31 * result + (this.generator == null ? 0 : this.generator.hashCode());
        result = 31 * result + (this.icon == null ? 0 : this.icon.hashCode());
        result = 31 * result + (int)(this.itemsPerPage ^ this.itemsPerPage >>> 32);
        result = 31 * result + (this.logo == null ? 0 : this.logo.hashCode());
        result = 31 * result + (this.rights == null ? 0 : this.rights.hashCode());
        result = 31 * result + (int)(this.startIndex ^ this.startIndex >>> 32);
        result = 31 * result + (this.subtitle == null ? 0 : this.subtitle.hashCode());
        result = 31 * result + (int)(this.totalResults ^ this.totalResults >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SyndFeed other = (SyndFeed)obj;
        if (this.entries == null ? other.entries != null : !((Object)this.entries).equals(other.entries)) {
            return false;
        }
        if (this.generator == null ? other.generator != null : !this.generator.equals(other.generator)) {
            return false;
        }
        if (this.icon == null ? other.icon != null : !this.icon.equals(other.icon)) {
            return false;
        }
        if (this.itemsPerPage != other.itemsPerPage) {
            return false;
        }
        if (this.logo == null ? other.logo != null : !this.logo.equals(other.logo)) {
            return false;
        }
        if (this.rights == null ? other.rights != null : !this.rights.equals(other.rights)) {
            return false;
        }
        if (this.startIndex != other.startIndex) {
            return false;
        }
        if (this.subtitle == null ? other.subtitle != null : !this.subtitle.equals(other.subtitle)) {
            return false;
        }
        return this.totalResults == other.totalResults;
    }
}

