/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen;

import com.atlassian.plugins.codegen.AmpsSystemPropertyVariable;
import com.atlassian.plugins.codegen.AmpsVersionUpdate;
import com.atlassian.plugins.codegen.ArtifactDependency;
import com.atlassian.plugins.codegen.BundleInstruction;
import com.atlassian.plugins.codegen.ManifestHeader;
import com.atlassian.plugins.codegen.MavenPlugin;
import com.atlassian.plugins.codegen.PluginArtifact;
import com.atlassian.plugins.codegen.PluginProjectChangeset;
import com.atlassian.plugins.codegen.ProjectPackaging;
import com.atlassian.plugins.codegen.ProjectRewriter;
import com.atlassian.plugins.codegen.TestBundleInstruction;
import com.atlassian.plugins.codegen.TestManifestHeader;
import com.atlassian.plugins.codegen.VersionId;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class MavenProjectRewriter
implements ProjectRewriter {
    private static final int POM_INDENTATION = 4;
    private static final String DEFAULT_INSTRUCTION_INDENT = StringUtils.repeat((String)" ", (int)28);
    private final File pomFile;
    private final Document document;
    private final Element root;
    private static final ImmutableSet<String> AMPS_PLUGIN_IDS = ImmutableSet.of((Object)"amps-maven-plugin", (Object)"bamboo-maven-plugin", (Object)"bitbucket-maven-plugin", (Object)"confluence-maven-plugin", (Object)"crowd-maven-plugin", (Object)"fecru-maven-plugin", (Object[])new String[]{"jira-maven-plugin", "refapp-maven-plugin"});

    public MavenProjectRewriter(File pom) throws DocumentException, IOException {
        this.pomFile = (File)Preconditions.checkNotNull((Object)pom, (Object)"pom");
        this.document = this.readPom(pom);
        this.root = this.document.getRootElement();
    }

    public void applyChanges(PluginProjectChangeset changes) throws IOException, DocumentException {
        boolean modifyPom = false;
        modifyPom |= this.applyPackagingChanges(changes.getItems(ProjectPackaging.class));
        modifyPom |= this.applyDependencyChanges(changes.getItems(ArtifactDependency.class));
        modifyPom |= this.applyMavenPluginChanges(changes.getItems(MavenPlugin.class));
        modifyPom |= this.applyManifestHeader(changes.getItems(ManifestHeader.class));
        modifyPom |= this.applyBundleInstructionChanges(changes.getItems(BundleInstruction.class));
        modifyPom |= this.applyPluginArtifactChanges(changes.getItems(PluginArtifact.class));
        modifyPom |= this.applyAmpsSystemPropertyChanges(changes.getItems(AmpsSystemPropertyVariable.class));
        if (modifyPom |= this.applyAmpsVersionUpdate(changes.getItems(AmpsVersionUpdate.class))) {
            this.writePom(this.document, this.pomFile);
        }
    }

    private boolean applyPackagingChanges(Iterable<ProjectPackaging> packagingChanges) {
        boolean modified = false;
        ProjectPackaging packaging = (ProjectPackaging)Iterables.getLast(packagingChanges, null);
        if (packaging == null) {
            return modified;
        }
        Element packagingElement = this.root.element("packaging");
        String desiredPackaging = packaging.getPackaging();
        if (packagingElement == null) {
            Element newPackagingElement = this.createElementWithValue("packaging", desiredPackaging);
            this.addElementAfterElement(this.root, newPackagingElement, "artifactId");
            modified = true;
        } else if (!desiredPackaging.equals(packagingElement.getText())) {
            packagingElement.setText(desiredPackaging);
            modified = true;
        }
        if ("atlassian-plugin".equals(desiredPackaging)) {
            modified |= this.enableAmpsExtensionsIfNecessary();
        }
        return modified;
    }

    private boolean enableAmpsExtensionsIfNecessary() {
        Element ampsPlugin = this.findAmpsPlugin();
        Element extensionsElement = ampsPlugin.element("extensions");
        if (extensionsElement == null) {
            Element newPackagingElement = this.createElementWithValue("extensions", "true");
            this.addElementAfterElement(ampsPlugin, newPackagingElement, "artifactId");
            return true;
        }
        if (!"true".equals(extensionsElement.getText())) {
            extensionsElement.setText("true");
            return true;
        }
        return false;
    }

    private boolean applyDependencyChanges(Iterable<ArtifactDependency> dependencies) {
        boolean modified = false;
        Element eDependencies = MavenProjectRewriter.getOrCreateElement(this.root, "dependencies");
        for (ArtifactDependency descriptor : dependencies) {
            boolean alreadyExists = Iterables.any((Iterable)eDependencies.elements("dependency"), (Predicate)Predicates.and(MavenProjectRewriter.childElementValue("groupId", descriptor.getGroupAndArtifactId().getGroupId().orElse("")), MavenProjectRewriter.childElementValue("artifactId", descriptor.getGroupAndArtifactId().getArtifactId())));
            if (alreadyExists) continue;
            modified = true;
            Element eNewDep = eDependencies.addElement("dependency");
            eNewDep.addElement("groupId").setText((String)descriptor.getGroupAndArtifactId().getGroupId().get());
            eNewDep.addElement("artifactId").setText(descriptor.getGroupAndArtifactId().getArtifactId());
            eNewDep.addElement("version").setText((String)descriptor.getVersionId().getVersionOrPropertyPlaceholder().get());
            this.createVersionPropertyIfNecessary(descriptor.getVersionId());
            eNewDep.addElement("scope").setText(descriptor.getScope().name().toLowerCase());
        }
        return modified;
    }

    private void createVersionPropertyIfNecessary(VersionId versionId) {
        versionId.getPropertyName().ifPresent(p -> {
            Element eProperties = MavenProjectRewriter.getOrCreateElement(this.root, "properties");
            if (eProperties.element(p) == null) {
                eProperties.addElement(p).setText(versionId.getVersion().orElse(""));
            }
        });
    }

    private boolean applyMavenPluginChanges(Iterable<MavenPlugin> mavenPlugins) throws DocumentException {
        boolean modified = false;
        Element ePlugins = MavenProjectRewriter.getOrCreateElement(this.root, "build/plugins");
        for (MavenPlugin descriptor : mavenPlugins) {
            Document fragDoc = DocumentHelper.parseText((String)("<root>" + descriptor.getXmlContent() + "</root>"));
            Optional groupId = descriptor.getGroupAndArtifactId().getGroupId();
            String artifactId = descriptor.getGroupAndArtifactId().getArtifactId();
            Predicate matchGroup = groupId.map(s -> MavenProjectRewriter.childElementValue("groupId", s)).orElseGet(() -> Predicates.or(MavenProjectRewriter.childElementValue("groupId", ""), MavenProjectRewriter.childElementValue("groupId", "org.apache.maven.plugins")));
            Predicate match = Predicates.and((Predicate)matchGroup, MavenProjectRewriter.childElementValue("artifactId", artifactId));
            if (Iterables.any((Iterable)ePlugins.elements("plugin"), (Predicate)match)) {
                modified |= this.mergeMavenPluginConfig((Element)Iterables.find((Iterable)ePlugins.elements("plugin"), (Predicate)match), fragDoc.getRootElement());
                continue;
            }
            ePlugins.add(this.toMavenPluginElement(descriptor, fragDoc.getRootElement()));
            modified = true;
        }
        return modified;
    }

    private boolean applyAmpsVersionUpdate(Iterable<AmpsVersionUpdate> items) {
        boolean modified = false;
        DefaultArtifactVersion newAmpsVersion = new DefaultArtifactVersion("0.0");
        for (AmpsVersionUpdate changeItem : items) {
            DefaultArtifactVersion changeVersion = new DefaultArtifactVersion(changeItem.getVersion());
            if (changeVersion.compareTo((ArtifactVersion)newAmpsVersion) > 0) {
                newAmpsVersion = changeVersion;
            }
            if ("plugin".equalsIgnoreCase(changeItem.getType()) && changeItem.isApplyConfig()) {
                modified = this.applyAmpsPluginVersionUpdate();
            }
            if ("management".equalsIgnoreCase(changeItem.getType()) && changeItem.isApplyConfig()) {
                boolean managementUpdated = this.applyAmpsPluginManagementVersionUpdate();
                if (!modified) {
                    modified = managementUpdated;
                }
            }
            if (!changeItem.isApplyProp()) continue;
            Element ampsVersionProperty = MavenProjectRewriter.getOrCreateElement(MavenProjectRewriter.getOrCreateElement(this.root, "properties"), "amps.version");
            if (StringUtils.isNotBlank((CharSequence)ampsVersionProperty.getTextTrim())) {
                DefaultArtifactVersion pomVersion = new DefaultArtifactVersion(ampsVersionProperty.getTextTrim());
                if (newAmpsVersion.compareTo((ArtifactVersion)pomVersion) <= 0) continue;
                modified = true;
                ampsVersionProperty.setText(newAmpsVersion.toString());
                continue;
            }
            ampsVersionProperty.setText(newAmpsVersion.toString());
            modified = true;
        }
        return modified;
    }

    private boolean applyAmpsPluginVersionUpdate() {
        boolean modified = false;
        Element ampsVersionElement = MavenProjectRewriter.getOrCreateElement(this.findAmpsPlugin(), "version");
        if (!"${amps.version}".equals(ampsVersionElement.getTextTrim())) {
            ampsVersionElement.setText("${amps.version}");
            modified = true;
        }
        return modified;
    }

    private boolean applyAmpsPluginManagementVersionUpdate() {
        Element ampsVersionElement;
        boolean modified = false;
        Element ampsManagementPlugin = this.findAmpsPluginManagement();
        if (null != ampsManagementPlugin && !"${amps.version}".equals((ampsVersionElement = MavenProjectRewriter.getOrCreateElement(ampsManagementPlugin, "version")).getTextTrim())) {
            ampsVersionElement.setText("${amps.version}");
            modified = true;
        }
        return modified;
    }

    public String getAmpsVersionInPom() {
        Element ampsVersion = MavenProjectRewriter.getElementOrNull(this.findAmpsPlugin(), "version");
        if (null != ampsVersion) {
            return ampsVersion.getTextTrim();
        }
        return "";
    }

    public boolean definesProperty(String propName) {
        Element properties = MavenProjectRewriter.getElementOrNull(this.root, "properties");
        if (null != properties) {
            return null != MavenProjectRewriter.getElementOrNull(properties, propName);
        }
        return false;
    }

    public String getAmpsPluginManagementVersionInPom() {
        Element ampsVersion;
        Element ampsManagementPlugin = this.findAmpsPluginManagement();
        String version = "";
        if (null != ampsManagementPlugin && null != (ampsVersion = MavenProjectRewriter.getElementOrNull(ampsManagementPlugin, "version"))) {
            version = ampsVersion.getTextTrim();
        }
        return version;
    }

    private boolean mergeMavenPluginConfig(Element ePlugin, Element paramsDesc) {
        boolean modified = false;
        Element eExecutions = MavenProjectRewriter.getOrCreateElement(ePlugin, "executions");
        for (Object node : paramsDesc.selectNodes("executions/execution")) {
            Element eExecution = (Element)node;
            String id = eExecution.elementTextTrim("id");
            if (Iterables.any((Iterable)eExecutions.elements("execution"), MavenProjectRewriter.childElementValue("id", id))) continue;
            this.detachAndAdd(eExecution, eExecutions);
            modified = true;
        }
        return modified;
    }

    private Element toMavenPluginElement(MavenPlugin descriptor, Element paramsDesc) {
        Element p = this.createElement("plugin");
        descriptor.getGroupAndArtifactId().getGroupId().ifPresent(groupId -> p.addElement("groupId").setText(groupId));
        p.addElement("artifactId").setText(descriptor.getGroupAndArtifactId().getArtifactId());
        if (descriptor.getVersionId().isDefined()) {
            p.addElement("version").setText((String)descriptor.getVersionId().getVersionOrPropertyPlaceholder().get());
            this.createVersionPropertyIfNecessary(descriptor.getVersionId());
        }
        if ("true".equals(paramsDesc.elementText("extensions"))) {
            p.addElement("extensions").setText("true");
        }
        for (Element oParam : paramsDesc.elements()) {
            this.detachAndAdd(oParam, p);
        }
        return p;
    }

    private boolean applyManifestHeader(Iterable<ManifestHeader> headers) {
        if (!headers.iterator().hasNext()) {
            return false;
        }
        Element configRoot = this.getAmpsPluginConfiguration();
        boolean modified = false;
        for (ManifestHeader header : headers) {
            Element instrRoot = MavenProjectRewriter.getOrCreateElement(configRoot, header instanceof TestManifestHeader ? "testInstructions" : "instructions");
            String headerName = header.getName();
            String headerValue = header.getValue();
            Element existingHeaderElement = instrRoot.element(headerName);
            if (existingHeaderElement == null) {
                Element newHeaderElement = this.createElementWithValue(headerName, headerValue);
                int maxPos = instrRoot.elements().size();
                int insertPos = header.getPosition() == -1 ? maxPos : Math.min(header.getPosition(), maxPos);
                instrRoot.elements().add(insertPos, newHeaderElement);
                modified = true;
                continue;
            }
            String body = existingHeaderElement.getText();
            if (StringUtils.equals((CharSequence)body, (CharSequence)headerValue)) continue;
            existingHeaderElement.setText(headerValue);
            modified = true;
        }
        return modified;
    }

    private boolean applyBundleInstructionChanges(Iterable<BundleInstruction> instructions) {
        if (!instructions.iterator().hasNext()) {
            return false;
        }
        Element configRoot = this.getAmpsPluginConfiguration();
        boolean modified = false;
        for (BundleInstruction instruction : instructions) {
            Element instrRoot = MavenProjectRewriter.getOrCreateElement(configRoot, instruction instanceof TestBundleInstruction ? "testInstructions" : "instructions");
            String categoryName = instruction.getCategory().getElementName();
            String packageName = instruction.getPackageName();
            Element categoryElement = MavenProjectRewriter.getOrCreateElement(instrRoot, categoryName);
            List<String> instructionLines = MavenProjectRewriter.toInstructionLines(categoryElement.getText());
            if (Iterables.any(instructionLines, s -> s != null && (s.equals(packageName) || s.startsWith(packageName + ";")))) continue;
            categoryElement.setText(MavenProjectRewriter.addInstructionLine(instructionLines, instruction));
            categoryElement.addAttribute(QName.get((String)"space", (Namespace)Namespace.XML_NAMESPACE), "preserve");
            modified = true;
        }
        return modified;
    }

    private static List<String> toInstructionLines(String body) {
        if (body == null || body.trim().isEmpty()) {
            return new ArrayList<String>();
        }
        return Arrays.stream(body.split(",")).map(String::trim).collect(Collectors.toList());
    }

    private static String addInstructionLine(List<String> instructionLines, BundleInstruction instruction) {
        ArrayList<String> allInstructions = new ArrayList<String>(instructionLines);
        MavenProjectRewriter.insertInAlphabeticalPosition(allInstructions, instruction.toInstructionLine());
        String indent = !instructionLines.isEmpty() ? MavenProjectRewriter.detectInstructionIndentation(instructionLines.get(0)) : DEFAULT_INSTRUCTION_INDENT;
        return MavenProjectRewriter.instructionListToString(allInstructions, indent);
    }

    private static String detectInstructionIndentation(String firstInstruction) {
        Pattern indentRegex = Pattern.compile("^\\n+([ \\t]*)\\S+");
        Matcher m = indentRegex.matcher(firstInstruction);
        if (m.matches()) {
            return m.group(1);
        }
        return DEFAULT_INSTRUCTION_INDENT;
    }

    private static void insertInAlphabeticalPosition(List<String> instructions, String newInstruction) {
        Pattern wildcardInstr = Pattern.compile("^\\s*\\*\\s*(;.*)?\\s*,?\\s*$");
        int insertPos = instructions.size();
        for (int i = 0; i < instructions.size(); ++i) {
            String trimmedLine = instructions.get(i);
            if (trimmedLine.compareTo(newInstruction) <= 0 && !wildcardInstr.matcher(trimmedLine).matches() || wildcardInstr.matcher(newInstruction).matches()) continue;
            insertPos = i;
            break;
        }
        instructions.add(insertPos, newInstruction);
    }

    private static String instructionListToString(List<String> instructions, String indent) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < instructions.size(); ++i) {
            buf.append("\n").append(indent).append(instructions.get(i));
            if (i >= instructions.size() - 1) continue;
            buf.append(",");
        }
        return buf.toString();
    }

    private boolean applyPluginArtifactChanges(Iterable<PluginArtifact> pluginArtifacts) {
        if (!pluginArtifacts.iterator().hasNext()) {
            return false;
        }
        Element configRoot = this.getAmpsPluginConfiguration();
        boolean modified = false;
        for (PluginArtifact p : pluginArtifacts) {
            String elementName = p.getType().getElementName();
            Element artifactsRoot = MavenProjectRewriter.getOrCreateElement(configRoot, elementName + "s");
            if (Iterables.any((Iterable)artifactsRoot.elements(elementName), (Predicate)Predicates.and(MavenProjectRewriter.childElementValue("groupId", p.getGroupAndArtifactId().getGroupId().orElse("")), MavenProjectRewriter.childElementValue("artifactId", p.getGroupAndArtifactId().getArtifactId())))) continue;
            artifactsRoot.add(this.toArtifactElement(p));
            modified = true;
        }
        return modified;
    }

    private boolean applyAmpsSystemPropertyChanges(Iterable<AmpsSystemPropertyVariable> propertyVariables) {
        if (!propertyVariables.iterator().hasNext()) {
            return false;
        }
        Element configRoot = this.getAmpsPluginConfiguration();
        boolean modified = false;
        for (AmpsSystemPropertyVariable propertyVariable : propertyVariables) {
            Element variablesRoot = MavenProjectRewriter.getOrCreateElement(configRoot, "systemPropertyVariables");
            if (variablesRoot.element(propertyVariable.getName()) != null) continue;
            variablesRoot.addElement(propertyVariable.getName()).setText(propertyVariable.getValue());
            modified = true;
        }
        return modified;
    }

    private Element toArtifactElement(PluginArtifact pluginArtifact) {
        Element ret = this.createElement(pluginArtifact.getType().getElementName());
        pluginArtifact.getGroupAndArtifactId().getGroupId().ifPresent(groupId -> ret.addElement("groupId").setText(groupId));
        ret.addElement("artifactId").setText(pluginArtifact.getGroupAndArtifactId().getArtifactId());
        if (pluginArtifact.getVersionId().isDefined()) {
            ret.addElement("version").setText((String)pluginArtifact.getVersionId().getVersionOrPropertyPlaceholder().get());
            this.createVersionPropertyIfNecessary(pluginArtifact.getVersionId());
        }
        return ret;
    }

    public static Optional<Element> getAmpsPluginElement(Document projectDoc) {
        return Optional.ofNullable(MavenProjectRewriter.getElementOrNull(projectDoc.getRootElement(), "build/plugins")).flatMap(plugins -> plugins.elements("plugin").stream().filter(p -> "com.atlassian.maven.plugins".equals(p.elementTextTrim("groupId")) && AMPS_PLUGIN_IDS.contains((Object)p.elementTextTrim("artifactId"))).findFirst());
    }

    private Element findAmpsPlugin() {
        return MavenProjectRewriter.getAmpsPluginElement(this.document).orElseThrow(() -> new IllegalStateException("Could not find AMPS plugin element in POM"));
    }

    private Element findAmpsPluginManagement() {
        Element plugins = MavenProjectRewriter.getElementOrNull(this.root, "build/pluginManagement/plugins");
        if (null != plugins) {
            for (Element p : plugins.elements("plugin")) {
                if (!"com.atlassian.maven.plugins".equals(p.elementTextTrim("groupId")) || !AMPS_PLUGIN_IDS.contains((Object)p.elementTextTrim("artifactId"))) continue;
                return p;
            }
        }
        return null;
    }

    private Element getAmpsPluginConfiguration() {
        return MavenProjectRewriter.getOrCreateElement(this.findAmpsPlugin(), "configuration");
    }

    private static Element getOrCreateElement(Element container, String path) {
        Element last = container;
        for (String pathName : path.split("/")) {
            last = container.element(pathName);
            if (last == null) {
                last = container.addElement(pathName);
            }
            container = last;
        }
        return last;
    }

    private static Element getElementOrNull(Element container, String path) {
        for (String pathName : path.split("/")) {
            if (container == null) continue;
            container = container.element(pathName);
        }
        return container;
    }

    private Document readPom(File f) throws DocumentException, IOException {
        SAXReader reader = new SAXReader();
        reader.setMergeAdjacentText(true);
        return reader.read(Files.newInputStream(f.toPath(), new OpenOption[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePom(Document doc, File f) throws IOException {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setNewLineAfterDeclaration(false);
        format.setIndentSize(4);
        format.setPadText(false);
        try (FileOutputStream fos = new FileOutputStream(f);
             XMLWriter writer = new XMLWriter((OutputStream)fos, format);){
            writer.write(doc);
        }
    }

    private Element createElement(String name) {
        return DocumentHelper.createElement((QName)new QName(name, this.root.getNamespace()));
    }

    private Element createElementWithValue(String name, String value) {
        Element e = this.createElement(name);
        e.setText(value);
        return e;
    }

    private void addElementAfterElement(Element parent, Element newElement, String afterElementName) {
        Element afterElement = parent.element(afterElementName);
        if (afterElement == null) {
            throw new IllegalStateException("Could not find element to insert after: " + afterElementName);
        }
        int index = parent.elements().indexOf(afterElement);
        parent.elements().add(index + 1, newElement);
    }

    private void fixNamespace(Element e) {
        e.setQName(new QName(e.getName(), this.root.getNamespace()));
        for (Element child : e.elements()) {
            this.fixNamespace(child);
        }
    }

    private void detachAndAdd(Element e, Element container) {
        e.detach();
        this.fixNamespace(e);
        container.add(e);
    }

    private static Predicate<Element> childElementValue(String name, String value) {
        return input -> {
            Element child = input.element(name);
            return child == null ? value.isEmpty() : value.equals(child.getText());
        };
    }
}

