/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.wadl;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.util.FileUtils;
import com.atlassian.maven.plugins.amps.util.JavaVersionProvider;
import com.atlassian.maven.plugins.amps.util.MojoExecutorWrapper;
import com.atlassian.maven.plugins.amps.util.PluginXmlUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@ParametersAreNonnullByDefault
public class RestDocsGenerator {
    private final MavenContext mavenContext;
    private final MojoExecutorWrapper mojoExecutorWrapper;
    private final JavaVersionProvider javaVersionProvider;

    public RestDocsGenerator(MavenContext mavenContext, MojoExecutorWrapper mojoExecutorWrapper, JavaVersionProvider javaVersionProvider) {
        this.mavenContext = Objects.requireNonNull(mavenContext);
        this.mojoExecutorWrapper = Objects.requireNonNull(mojoExecutorWrapper);
        this.javaVersionProvider = Objects.requireNonNull(javaVersionProvider);
    }

    private Log log() {
        return this.mavenContext.getLog();
    }

    private MavenProject mavenProject() {
        return this.mavenContext.getProject();
    }

    public void generateRestDocs(@Nullable String jacksonModules) throws MojoExecutionException {
        if (this.javaVersionProvider.getMajor() >= 13) {
            this.log().info((CharSequence)"Skipping REST documentation generation as it is not supported on Java 13 or greater");
            return;
        }
        if (this.isRestApiV2InClasspath()) {
            this.log().info((CharSequence)"Skipping REST documentation generation as it is not supported with REST API V2");
            return;
        }
        List<PluginXmlUtils.RESTModuleInfo> restModules = PluginXmlUtils.getRestModules(this.mavenContext);
        if (restModules.isEmpty()) {
            this.log().info((CharSequence)"No REST modules found, skipping WADL doc generation");
            return;
        }
        this.withoutGlobalJavadocPlugin(() -> this.invokeJavadocPluginWithCustomDoclet(restModules, jacksonModules));
        this.generateApplicationXmlFiles();
    }

    private boolean isRestApiV2InClasspath() {
        return this.mavenProject().getArtifacts().stream().anyMatch(artifact -> artifact.getGroupId().equals("com.atlassian.plugins.rest") && artifact.getArtifactId().equals("atlassian-rest-v2-api"));
    }

    private void invokeJavadocPluginWithCustomDoclet(List<PluginXmlUtils.RESTModuleInfo> restModules, @Nullable String jacksonModules) {
        try {
            this.mojoExecutorWrapper.executeWithMergedConfig(this.mavenContext.getPlugin("org.apache.maven.plugins", "maven-javadoc-plugin"), MojoExecutor.goal("javadoc"), MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("maxmemory"), "1024m"), MojoExecutor.element(MojoExecutor.name("sourcepath"), this.getPackagesPath(restModules)), MojoExecutor.element(MojoExecutor.name("doclet"), "com.atlassian.jersey.wadl.doclet.ResourceDocletJSON"), MojoExecutor.element(MojoExecutor.name("docletPath"), String.join((CharSequence)File.pathSeparator, this.getDocletPathElements())), MojoExecutor.element(MojoExecutor.name("docletArtifacts"), MojoExecutor.element(MojoExecutor.name("docletArtifact"), MojoExecutor.element(MojoExecutor.name("groupId"), "com.atlassian.plugins.rest"), MojoExecutor.element(MojoExecutor.name("artifactId"), "atlassian-rest-doclet"), MojoExecutor.element(MojoExecutor.name("version"), "6.1.9")), MojoExecutor.element(MojoExecutor.name("docletArtifact"), MojoExecutor.element(MojoExecutor.name("groupId"), "com.atlassian.jersey"), MojoExecutor.element(MojoExecutor.name("artifactId"), "atlassian-jersey-restdoc"), MojoExecutor.element(MojoExecutor.name("version"), "2.0.0")), MojoExecutor.element(MojoExecutor.name("docletArtifact"), MojoExecutor.element(MojoExecutor.name("groupId"), "xerces"), MojoExecutor.element(MojoExecutor.name("artifactId"), "xercesImpl"), MojoExecutor.element(MojoExecutor.name("version"), "2.12.1")), MojoExecutor.element(MojoExecutor.name("docletArtifact"), MojoExecutor.element(MojoExecutor.name("groupId"), "commons-lang"), MojoExecutor.element(MojoExecutor.name("artifactId"), "commons-lang"), MojoExecutor.element(MojoExecutor.name("version"), "2.6")), MojoExecutor.element(MojoExecutor.name("docletArtifact"), MojoExecutor.element(MojoExecutor.name("groupId"), "com.sun.istack"), MojoExecutor.element(MojoExecutor.name("artifactId"), "istack-commons-runtime"), MojoExecutor.element(MojoExecutor.name("version"), "3.0.11"))), MojoExecutor.element(MojoExecutor.name("outputDirectory"), new MojoExecutor.Element[0]), MojoExecutor.element(MojoExecutor.name("additionalOptions"), this.getAdditionalOptions(jacksonModules)), MojoExecutor.element(MojoExecutor.name("useStandardDocletOptions"), "false")), this.mavenContext.getExecutionEnvironment());
        }
        catch (MojoExecutionException e) {
            this.log().warn((CharSequence)"Could not generate REST documentation. Please verify that Atlassian REST is a 'provided' scope dependency of the plugin.", (Throwable)e);
        }
    }

    private MojoExecutor.Element[] getAdditionalOptions(@Nullable String jacksonModules) {
        String resourcedocPath = FileUtils.fixWindowsSlashes(this.mavenProject().getBuild().getOutputDirectory() + File.separator + "resourcedoc.xml");
        ArrayList<MojoExecutor.Element> additionalOptions = new ArrayList<MojoExecutor.Element>();
        additionalOptions.add(MojoExecutor.element(MojoExecutor.name("additionalOption"), "-output \"" + resourcedocPath + "\""));
        if (jacksonModules != null) {
            additionalOptions.add(MojoExecutor.element(MojoExecutor.name("additionalOption"), " -modules \"" + jacksonModules + "\""));
        }
        return additionalOptions.toArray(new MojoExecutor.Element[0]);
    }

    private Set<String> getDocletPathElements() throws MojoExecutionException {
        try {
            LinkedHashSet<String> docletPathElements = new LinkedHashSet<String>();
            docletPathElements.add(this.mavenProject().getBuild().getOutputDirectory());
            docletPathElements.addAll(this.mavenProject().getCompileClasspathElements());
            docletPathElements.addAll(this.mavenProject().getRuntimeClasspathElements());
            docletPathElements.addAll(this.mavenProject().getSystemClasspathElements());
            docletPathElements.addAll(RestDocsGenerator.getPluginClasspathElements());
            return docletPathElements;
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Dependencies must be resolved", (Exception)((Object)e));
        }
    }

    @VisibleForTesting
    static List<String> getPluginClasspathElements() {
        URL[] pluginUrls = ((URLClassLoader)Thread.currentThread().getContextClassLoader()).getURLs();
        return Arrays.stream(pluginUrls).map(URL::getFile).map(File::new).map(File::getPath).collect(Collectors.toList());
    }

    private String getPackagesPath(Collection<PluginXmlUtils.RESTModuleInfo> restModules) {
        if (this.anyRestModuleHasNoExplicitPackages(restModules)) {
            String sourceDirectory = this.mavenProject().getBuild().getSourceDirectory();
            this.log().info((CharSequence)String.format("Scanning all of %s for REST resources", sourceDirectory));
            return sourceDirectory;
        }
        return restModules.stream().flatMap(module -> module.getPackagesToScan().stream()).map(this::getAbsoluteDirectory).distinct().collect(Collectors.joining(File.pathSeparator));
    }

    private boolean anyRestModuleHasNoExplicitPackages(Collection<PluginXmlUtils.RESTModuleInfo> restModules) {
        return restModules.stream().map(PluginXmlUtils.RESTModuleInfo::getPackagesToScan).anyMatch(List::isEmpty);
    }

    private String getAbsoluteDirectory(String packageName) {
        String relativePackageDirectory = packageName.replaceAll("\\.", Matcher.quoteReplacement(File.separator));
        return this.mavenProject().getBuild().getSourceDirectory() + File.separator + relativePackageDirectory;
    }

    private void generateApplicationXmlFiles() throws MojoExecutionException {
        try {
            PluginXmlUtils.PluginInfo pluginInfo = PluginXmlUtils.getPluginInfo(this.mavenContext);
            this.generateApplicationXmlFile("application-doc.xml", template -> {
                String intermediate = StringUtils.replace((String)template, (String)"${rest.doc.title}", (String)pluginInfo.getName());
                return StringUtils.replace((String)intermediate, (String)"${rest.doc.description}", (String)pluginInfo.getDescription());
            });
            this.generateApplicationXmlFile("application-grammars.xml", Function.identity());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error writing REST application XML files", e);
        }
    }

    private void generateApplicationXmlFile(String filename, Function<String, String> fileContentTransformer) throws IOException {
        File outputFile = new File(this.mavenProject().getBuild().getOutputDirectory(), filename);
        if (!outputFile.exists()) {
            String defaultFileContent = IOUtils.resourceToString((String)filename, (Charset)StandardCharsets.UTF_8, (ClassLoader)this.getClass().getClassLoader());
            String transformedFileContent = fileContentTransformer.apply(defaultFileContent);
            org.apache.commons.io.FileUtils.writeStringToFile((File)outputFile, (String)transformedFileContent, (Charset)StandardCharsets.UTF_8);
            this.log().info((CharSequence)("Wrote " + outputFile.getAbsolutePath()));
        }
    }

    private void withoutGlobalJavadocPlugin(CustomJavadocAction javadocAction) throws MojoExecutionException {
        Plugin globalJavadoc = this.mavenProject().getPlugin("org.apache.maven.plugins:maven-javadoc-plugin");
        if (globalJavadoc != null) {
            this.mavenProject().getBuild().removePlugin(globalJavadoc);
        }
        javadocAction.invoke();
        if (globalJavadoc != null) {
            this.mavenProject().getBuild().addPlugin(globalJavadoc);
        }
    }

    private static interface CustomJavadocAction {
        public void invoke() throws MojoExecutionException;
    }
}

