/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util.manifest;

import com.atlassian.maven.plugins.amps.util.manifest.ParsedManifest;
import com.atlassian.plugins.codegen.BundleInstruction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class ManifestUtils {
    private static final String KEY_ATTRS = "attributes";
    private static final String KEY_DIRS = "directives";

    public static List<BundleInstruction> mapParsedManifestToBundleInstructions(ParsedManifest parsedManifest) {
        ArrayList<BundleInstruction> bundleInstructions = new ArrayList<BundleInstruction>();
        Map<String, Object> manifestMap = parsedManifest.getManifestMap();
        for (String key : manifestMap.keySet()) {
            Optional instrCatOpt = BundleInstruction.Category.fromElementName((String)key);
            if (!instrCatOpt.isPresent()) continue;
            Map packages = (Map)manifestMap.get(key);
            for (String pkg : packages.keySet()) {
                Map pkgInfo = packages.getOrDefault(pkg, Collections.emptyMap());
                String version = pkgInfo.getOrDefault(KEY_ATTRS, Collections.emptyMap()).getOrDefault("version", "");
                version = (version = StringUtils.strip((String)version, (String)"\"")).isEmpty() ? null : version;
                String resolution = (String)pkgInfo.getOrDefault(KEY_DIRS, Collections.emptyMap()).get("resolution");
                boolean isOptional = "optional".equalsIgnoreCase(StringUtils.strip((String)resolution, (String)"\""));
                bundleInstructions.add(new BundleInstruction((BundleInstruction.Category)instrCatOpt.get(), pkg, version, isOptional));
            }
        }
        return bundleInstructions;
    }

    public static List<BundleInstruction> dropInstructionVersionConstraints(List<BundleInstruction> instructions) {
        ArrayList<BundleInstruction> updatedInstructions = new ArrayList<BundleInstruction>();
        for (BundleInstruction instruction : instructions) {
            updatedInstructions.add(instruction.dropVersion());
        }
        return updatedInstructions;
    }

    public static List<BundleInstruction> subtractInstructions(List<BundleInstruction> fromInstructions, List<BundleInstruction> instructionsToSubtract) {
        ArrayList<BundleInstruction> resultInstructions = new ArrayList<BundleInstruction>(fromInstructions);
        for (BundleInstruction instrToSubtr : instructionsToSubtract) {
            resultInstructions.removeIf(instr -> instr.equalsCategoryAndPackageName(instrToSubtr));
        }
        return resultInstructions;
    }
}

