/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util;

import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.util.FileUtils;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;

public final class ProjectUtils {
    private static final List<String> ATLASSIAN_GROUP_ID_PREFIXES = Arrays.asList("com.atlassian", "io.atlassian", "net.java.dev.activeobjects", "com.riadalabs", "io.riada", "com.thinktilt.proforma", "com.pyxis.greenhopper");

    public static boolean shouldDeployTestJar(MavenContext context) {
        File testResources = FileUtils.file(context.getProject().getBasedir(), "src", "test", "resources");
        File pluginXml = new File(testResources, "atlassian-plugin.xml");
        return pluginXml.exists();
    }

    public static <T> T firstNotNull(T ... values) {
        return (T)Arrays.stream(values).filter(Objects::nonNull).findFirst().orElseThrow(() -> new NullPointerException("All values are null"));
    }

    @Nonnull
    public static File createDirectory(@Nonnull File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalStateException("Failed to create directory " + dir.getAbsolutePath());
        }
        return dir;
    }

    @Nullable
    public static Artifact getReactorArtifact(MavenContext context, String groupId, String artifactId) {
        return context.getProject().getArtifacts().stream().filter(a -> a.getGroupId().equals(groupId)).filter(a -> a.getArtifactId().equals(artifactId)).findFirst().orElse(null);
    }

    public static boolean hasAtlassianGroupId(String groupId) {
        return ATLASSIAN_GROUP_ID_PREFIXES.stream().anyMatch(prefix -> groupId.startsWith(String.format("%s.", prefix)) || groupId.equals(prefix));
    }

    public static boolean isAtlassianProject(@CheckForNull MavenProject project) {
        if (project != null) {
            String groupId = project.getArtifact().getGroupId();
            return ProjectUtils.hasAtlassianGroupId(groupId);
        }
        return false;
    }

    private ProjectUtils() {
    }
}

