/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util;

import com.atlassian.maven.plugins.amps.util.AmpsPluginVersionChecker;
import com.atlassian.maven.plugins.amps.util.NOOPProjectRewriter;
import com.atlassian.plugins.codegen.AmpsVersionUpdate;
import com.atlassian.plugins.codegen.MavenProjectRewriter;
import com.atlassian.plugins.codegen.PluginProjectChange;
import com.atlassian.plugins.codegen.PluginProjectChangeset;
import com.atlassian.plugins.codegen.ProjectRewriter;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.prefs.Preferences;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.dom4j.DocumentException;

public class AmpsPluginVersionCheckerImpl
extends AbstractLogEnabled
implements AmpsPluginVersionChecker {
    private static final List<String> YN_ANSWERS = new ArrayList<String>(Arrays.asList("Y", "y", "N", "n"));
    public static final String NO_VERSION_DEFINED = "no-version-defined";
    public static final String POM_UPDATE_PREF_PREFIX = "sdk-pom-update-check";
    private Prompter prompter;
    private boolean skipCheck;

    @Override
    public void checkAmpsVersionInPom(String currentVersion, MavenProject project) {
        if (this.skipCheck || project.getFile() == null || !project.getFile().exists()) {
            return;
        }
        String prefKey = "sdk-pom-update-check-" + currentVersion + "-" + DigestUtils.md5Hex((String)project.getArtifactId());
        Preferences prefs = Preferences.userNodeForPackage(AmpsPluginVersionCheckerImpl.class);
        String alreadyRan = prefs.get(prefKey, null);
        if (alreadyRan != null) {
            return;
        }
        prefs.put(prefKey, "true");
        try {
            boolean pluginNeedsUpdate;
            DefaultArtifactVersion runningVersion = new DefaultArtifactVersion(currentVersion);
            VersionInfo versionInfo = this.getVersionAndRewriter(project);
            ArtifactVersion versionInPom = versionInfo.artifactVersion;
            PomVersionElement pomElement = versionInfo.pomVersionElement;
            String pomElementType = pomElement.getType();
            ProjectRewriter rewriter = versionInfo.projectRewriter;
            boolean managementNeedsUpdate = pomElementType.equals("management") && this.versionInPomIsOlderOrNotDefined((ArtifactVersion)runningVersion, versionInPom);
            boolean bl = pluginNeedsUpdate = pomElementType.equals("plugin") && this.versionInPomIsOlderOrNotDefined((ArtifactVersion)runningVersion, versionInPom);
            if ((pluginNeedsUpdate || managementNeedsUpdate) && this.promptToUpdatePom(versionInPom, (ArtifactVersion)runningVersion)) {
                rewriter.applyChanges(this.getPluginProjectChanges(currentVersion, managementNeedsUpdate, pluginNeedsUpdate));
                String versionProp = pomElement.getVersionProperty();
                ProjectRewriter propRewriter = StringUtils.isNotBlank((CharSequence)versionProp) ? (ProjectRewriter)this.getRewriterForVersionProp(versionProp, project).orElse(null) : rewriter;
                if (propRewriter == null) {
                    this.getLogger().error("unable to update AMPS version in POM");
                } else {
                    PluginProjectChangeset propChanges = new PluginProjectChangeset().with(new PluginProjectChange[]{AmpsVersionUpdate.ampsVersionUpdate((String)currentVersion, (String)"plugin", (boolean)false, (boolean)true)});
                    propRewriter.applyChanges(propChanges);
                    this.getLogger().info("AMPS version in pom updated to " + currentVersion);
                }
            }
        }
        catch (Exception t) {
            this.getLogger().error("unable to check AMPS version in POM...", (Throwable)t);
        }
    }

    private PluginProjectChangeset getPluginProjectChanges(String currentVersion, boolean managementNeedsUpdate, boolean pluginNeedsUpdate) {
        PluginProjectChangeset changes = new PluginProjectChangeset();
        if (pluginNeedsUpdate) {
            changes = changes.with(new PluginProjectChange[]{AmpsVersionUpdate.ampsVersionUpdate((String)currentVersion, (String)"plugin", (boolean)true, (boolean)false)});
        }
        if (managementNeedsUpdate) {
            changes = changes.with(new PluginProjectChange[]{AmpsVersionUpdate.ampsVersionUpdate((String)currentVersion, (String)"management", (boolean)true, (boolean)false)});
        }
        return changes;
    }

    private boolean versionInPomIsOlderOrNotDefined(ArtifactVersion runningVersion, ArtifactVersion versionInPom) {
        return NO_VERSION_DEFINED.equalsIgnoreCase(versionInPom.toString()) || runningVersion.compareTo((Object)versionInPom) > 0;
    }

    private VersionInfo getVersionAndRewriter(MavenProject project) throws IOException, DocumentException {
        DefaultArtifactVersion ampsVersionInPom;
        if (project.getFile() == null || !project.getFile().exists()) {
            return new VersionInfo((ArtifactVersion)new DefaultArtifactVersion(NO_VERSION_DEFINED), new PomVersionElement("management", null), new NOOPProjectRewriter());
        }
        MavenProjectRewriter rewriter = new MavenProjectRewriter(project.getFile());
        String managementVersionInPom = rewriter.getAmpsPluginManagementVersionInPom();
        String pluginVersionInPom = "";
        DefaultArtifactVersion ampsManagementVersionInPom = this.getPomVersion(managementVersionInPom, project);
        try {
            pluginVersionInPom = rewriter.getAmpsVersionInPom();
            ampsVersionInPom = this.getPomVersion(pluginVersionInPom, project);
        }
        catch (IllegalStateException e) {
            ampsVersionInPom = new DefaultArtifactVersion(NO_VERSION_DEFINED);
        }
        String versionProp = "";
        if (managementVersionInPom.startsWith("$")) {
            versionProp = managementVersionInPom;
        }
        if (pluginVersionInPom.startsWith("$")) {
            versionProp = pluginVersionInPom;
        }
        if (project.hasParent() && !AmpsPluginVersionCheckerImpl.isDefined((ArtifactVersion)ampsManagementVersionInPom) && !AmpsPluginVersionCheckerImpl.isDefined((ArtifactVersion)ampsVersionInPom)) {
            return this.getVersionAndRewriter(project.getParent());
        }
        if (AmpsPluginVersionCheckerImpl.isDefined((ArtifactVersion)ampsManagementVersionInPom)) {
            return new VersionInfo((ArtifactVersion)ampsManagementVersionInPom, new PomVersionElement("management", versionProp), (ProjectRewriter)rewriter);
        }
        return new VersionInfo((ArtifactVersion)ampsVersionInPom, new PomVersionElement("plugin", versionProp), (ProjectRewriter)rewriter);
    }

    private static boolean isDefined(ArtifactVersion artifactVersion) {
        return artifactVersion != null && !NO_VERSION_DEFINED.equalsIgnoreCase(artifactVersion.toString());
    }

    @Nonnull
    private Optional<ProjectRewriter> getRewriterForVersionProp(String versionProp, MavenProject project) throws IOException, DocumentException {
        if (project.getFile() == null || !project.getFile().exists()) {
            return Optional.empty();
        }
        MavenProjectRewriter rewriter = new MavenProjectRewriter(project.getFile());
        String propName = StringUtils.substringBetween((String)versionProp, (String)"${", (String)"}");
        if (StringUtils.isNotBlank((CharSequence)propName) && rewriter.definesProperty(propName)) {
            return Optional.of(rewriter);
        }
        if (project.hasParent()) {
            return this.getRewriterForVersionProp(versionProp, project.getParent());
        }
        return Optional.empty();
    }

    @Override
    public void skipPomCheck(boolean skip) {
        this.skipCheck = skip;
    }

    private boolean promptToUpdatePom(ArtifactVersion ampsVersionInPom, ArtifactVersion runningVersion) throws PrompterException {
        String prompt = MessageUtils.buffer().warning((Object)"You are running AMPS plugin version ").warning((Object)runningVersion).warning((Object)" but your POM is using version ").warning((Object)ampsVersionInPom).newline().strong((Object)"Would you like to have your POM updated?").build();
        return this.promptForBoolean(prompt);
    }

    @Nullable
    private DefaultArtifactVersion getPomVersion(String ampsVersionOrProperty, MavenProject project) {
        DefaultArtifactVersion ampsVersionInPom = null;
        if (StringUtils.isNotBlank((CharSequence)ampsVersionOrProperty) && ampsVersionOrProperty.startsWith("$")) {
            String propName = StringUtils.substringBetween((String)ampsVersionOrProperty, (String)"${", (String)"}");
            if (StringUtils.isNotBlank((CharSequence)propName)) {
                ampsVersionInPom = new DefaultArtifactVersion(project.getProperties().getProperty(propName, "0.0"));
            }
        } else {
            ampsVersionInPom = StringUtils.isNotBlank((CharSequence)ampsVersionOrProperty) ? new DefaultArtifactVersion(ampsVersionOrProperty) : new DefaultArtifactVersion(NO_VERSION_DEFINED);
        }
        return ampsVersionInPom;
    }

    private boolean promptForBoolean(String message) throws PrompterException {
        String answer = StringUtils.isBlank((CharSequence)"Y") ? this.prompter.prompt(message, YN_ANSWERS) : this.prompter.prompt(message, YN_ANSWERS, "Y");
        return "y".equalsIgnoreCase(answer);
    }

    static class PomVersionElement {
        public static final String PLUGIN = "plugin";
        public static final String MANAGEMENT = "management";
        private final String type;
        private final String versionProperty;

        private PomVersionElement(String type, String versionProperty) {
            this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type");
            this.versionProperty = versionProperty;
        }

        public String getType() {
            return this.type;
        }

        public String getVersionProperty() {
            return this.versionProperty;
        }
    }

    private static class VersionInfo {
        private final ArtifactVersion artifactVersion;
        private final PomVersionElement pomVersionElement;
        private final ProjectRewriter projectRewriter;

        private VersionInfo(ArtifactVersion artifactVersion, PomVersionElement pomVersionElement, ProjectRewriter projectRewriter) {
            this.artifactVersion = artifactVersion;
            this.pomVersionElement = pomVersionElement;
            this.projectRewriter = projectRewriter;
        }
    }
}

