/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.transform;

import com.atlassian.maven.plugins.amps.codegen.prompter.PluginModulePrompter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

public class TransformPrompter {
    private final Prompter prompter;
    private final boolean skipPrompts;
    private final Log log;

    TransformPrompter(Prompter prompter, boolean skipPrompts, Log log) {
        this.prompter = prompter;
        this.skipPrompts = skipPrompts;
        this.log = log;
    }

    public boolean shouldTransformTestPlugin() throws MojoExecutionException {
        String confirmed;
        if (this.skipPrompts) {
            return true;
        }
        this.logLineBreak();
        try {
            confirmed = this.prompter.prompt("Accompanying test plugin detected. Include in conversion?", PluginModulePrompter.YN_ANSWERS, "y");
        }
        catch (PrompterException e) {
            throw new MojoExecutionException((Throwable)e);
        }
        this.logLineBreak();
        return "y".equalsIgnoreCase(confirmed);
    }

    public boolean confirmTransformation() throws MojoExecutionException {
        String confirmed;
        if (this.skipPrompts) {
            return true;
        }
        this.logLineBreak();
        try {
            confirmed = this.prompter.prompt("This will convert your plugin project to be transformerless. It involves modifying the project source, please ensure you have backed up or committed the current state. Continue?", PluginModulePrompter.YN_ANSWERS, "y");
        }
        catch (PrompterException e) {
            throw new MojoExecutionException((Throwable)e);
        }
        this.logLineBreak();
        return "y".equalsIgnoreCase(confirmed);
    }

    private void logLineBreak() {
        this.log.info((CharSequence)"");
    }
}

