/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.transform;

import com.atlassian.maven.plugins.amps.AbstractProductAwareMojo;
import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.product.common.XMLDocumentHandler;
import com.atlassian.maven.plugins.amps.transform.TransformConfigFactory;
import com.atlassian.maven.plugins.amps.transform.TransformContext;
import com.atlassian.maven.plugins.amps.transform.TransformPrompter;
import com.atlassian.plugins.codegen.MavenProjectRewriter;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.dom4j.Document;

@Mojo(name="transform", requiresDependencyResolution=ResolutionScope.TEST)
@Execute(phase=LifecyclePhase.PACKAGE)
public class TransformMojo
extends AbstractProductAwareMojo {
    private boolean isInitialized = false;
    private TransformContext transformContext;
    private TransformContext testTransformContext;
    private TransformPrompter transformPrompter;
    private boolean shouldTransformMainPlugin;
    private boolean shouldTransformTestPlugin;
    @Component
    private Prompter prompter;
    @Parameter
    private Map<String, String> instructions;
    @Parameter(property="cacheTransformedJarPath")
    private String cacheTransformedJarPath;
    @Parameter(property="testPluginOnly", defaultValue="false")
    private boolean testPluginOnly;
    @Parameter
    private Map<String, String> testInstructions;
    @Parameter(property="cacheTransformedTestJarPath")
    private String cacheTransformedTestJarPath;

    public TransformMojo() {
    }

    @VisibleForTesting
    TransformMojo(MavenContext mavenContext, Log log, TransformContext transformContext, TransformContext testTransformContext, TransformPrompter transformPrompter, boolean testPluginOnly) {
        this.setMavenContext(mavenContext);
        this.setLog(log);
        this.transformContext = transformContext;
        this.testTransformContext = testTransformContext;
        this.transformPrompter = transformPrompter;
        this.testPluginOnly = testPluginOnly;
        this.isInitialized = true;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.validateAmpsPluginElement();
        this.initialize();
        this.validateRequiredPluginDescriptorExists();
        this.populateTransformationFlags();
        if (!this.shouldTransformMainPlugin && !this.shouldTransformTestPlugin) {
            this.getLog().info((CharSequence)"No plugins eligible for transformerless conversion. Skipping goal.");
            return;
        }
        this.performPreFlightValidation();
        if (!this.transformPrompter.confirmTransformation()) {
            this.getLog().info((CharSequence)"Transformerless conversion cancelled.");
            return;
        }
        this.executeTransformation();
    }

    private void initialize() {
        if (this.isInitialized) {
            return;
        }
        this.transformPrompter = new TransformPrompter(this.prompter, this.shouldSkipPrompts(), this.getLog());
        this.transformContext = new TransformContext(TransformConfigFactory.pluginConfig(this.instructions, this.cacheTransformedJarPath), this.getProductId(), this.getMavenContext(), this.getLog());
        this.testTransformContext = new TransformContext(TransformConfigFactory.testPluginConfig(this.testInstructions, this.cacheTransformedTestJarPath), this.getProductId(), this.getMavenContext(), this.getLog());
        this.isInitialized = true;
    }

    private void validateRequiredPluginDescriptorExists() throws MojoExecutionException {
        (this.testPluginOnly ? this.testTransformContext : this.transformContext).validator().validatePluginDescriptorExists();
    }

    private void populateTransformationFlags() throws MojoExecutionException {
        this.shouldTransformMainPlugin = !this.testPluginOnly && this.transformContext.validator().canBeTransformed();
        this.shouldTransformTestPlugin = this.determineTestPluginTransformationIntent() && this.testTransformContext.validator().canBeTransformed();
    }

    private boolean determineTestPluginTransformationIntent() throws MojoExecutionException {
        if (this.testPluginOnly) {
            return true;
        }
        return this.testTransformContext.validator().doesPluginDescriptorExist() && this.transformPrompter.shouldTransformTestPlugin();
    }

    private void performPreFlightValidation() throws MojoExecutionException {
        if (this.shouldTransformMainPlugin) {
            this.transformContext.executor().locateTransformedJar();
        }
        if (this.shouldTransformTestPlugin) {
            this.testTransformContext.executor().locateTransformedJar();
        }
    }

    private void executeTransformation() throws MojoExecutionException {
        if (this.shouldTransformMainPlugin) {
            this.transformContext.executor().performTransformation();
        }
        if (this.shouldTransformTestPlugin) {
            this.testTransformContext.executor().performTransformation();
        }
    }

    private void validateAmpsPluginElement() throws MojoExecutionException {
        MavenProjectRewriter.getAmpsPluginElement((Document)XMLDocumentHandler.parse(this.getMavenContext().getProject().getFile())).orElseThrow(() -> new MojoExecutionException("AMPS plugin definition not found in current project POM."));
    }
}

