/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product.manager;

import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BaseUrlUtils {
    private static final Logger log = LoggerFactory.getLogger(BaseUrlUtils.class);
    private static final Pattern SCHEME_PATTERN = Pattern.compile("^https?://");

    public static String getBaseUrl(String server, int actualWebPort, @Nullable String contextPath, boolean useHttps) {
        return BaseUrlUtils.formatServer(server, useHttps) + BaseUrlUtils.formatPort(server, actualWebPort, useHttps) + BaseUrlUtils.formatContextPath(contextPath);
    }

    public static String getProtocol(boolean useHttps) {
        return useHttps ? "https" : "http";
    }

    private static String formatServer(String server, boolean useHttps) {
        if (StringUtils.isBlank((CharSequence)server)) {
            throw new IllegalArgumentException(String.format("Invalid server name '%s'", server));
        }
        if (SCHEME_PATTERN.matcher(server).find()) {
            log.warn("Deprecated: detected http(s):// in the 'server' property '{}'", (Object)server);
            return server;
        }
        return String.format("%s://%s", BaseUrlUtils.getProtocol(useHttps), server);
    }

    private static String formatPort(String server, int port, boolean useHttps) {
        int defaultPort = 80;
        if (server.startsWith("https://") || useHttps) {
            defaultPort = 443;
        }
        return port != defaultPort ? ":" + port : "";
    }

    private static String formatContextPath(String contextPath) {
        if (StringUtils.isBlank((CharSequence)contextPath)) {
            return "";
        }
        return StringUtils.prependIfMissing((String)contextPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }

    private BaseUrlUtils() {
    }
}

