/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.ConfluenceBundledLibrariesManifestReader;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.maven.plugin.logging.Log;

final class ConfluenceEmbeddedDatabaseResolver {
    static final ProductArtifact H2 = new ProductArtifact("com.h2database", "h2", "1.4.200");
    static final ProductArtifact HSQLDB = new ProductArtifact("org.hsqldb", "hsqldb", "2.3.0");
    private final Log log;
    private final WarFileBundledLibrariesManifestReader warFileBundledLibrariesMetadataReader;

    public ConfluenceEmbeddedDatabaseResolver(Log log) {
        this(log, new ConfluenceBundledLibrariesManifestReader()::readBundledLibrariesManifest);
    }

    public ConfluenceEmbeddedDatabaseResolver(Log log, WarFileBundledLibrariesManifestReader warFileBundledLibrariesMetadataReader) {
        this.log = Objects.requireNonNull(log);
        this.warFileBundledLibrariesMetadataReader = Objects.requireNonNull(warFileBundledLibrariesMetadataReader);
    }

    public List<ProductArtifact> getExtraEmbeddedDatabaseDependencies(Product product, File warFile) {
        Optional<Set<ProductArtifact>> bundledLibraries = this.readBundledLibrariesMetadata(warFile);
        bundledLibraries.ifPresent(libs -> this.info("Confluence WAR file contains bundled library metadata", new Object[0]));
        return Stream.of(H2, HSQLDB).map(dbArtifact -> this.getExtraEmbeddedDatabaseDependency(product, (ProductArtifact)dbArtifact, bundledLibraries.orElse(null))).flatMap(this::stream).collect(Collectors.toList());
    }

    private Optional<ProductArtifact> getExtraEmbeddedDatabaseDependency(Product product, ProductArtifact dbArtifact, @Nullable Set<ProductArtifact> bundledLibraries) {
        if (bundledLibraries == null) {
            this.log.debug((CharSequence)"Confluence WAR contains no bundled library metadata, assuming embedded database dependencies are bundled");
            return Optional.empty();
        }
        if (ConfluenceEmbeddedDatabaseResolver.containsGroupAndArtifactMatch(bundledLibraries, dbArtifact)) {
            this.info("Confluence WAR contains bundled embedded database %s:%s", dbArtifact.getGroupId(), dbArtifact.getArtifactId());
            return Optional.empty();
        }
        if (ConfluenceEmbeddedDatabaseResolver.containsGroupAndArtifactMatch(product.getLibArtifacts(), dbArtifact)) {
            this.info("AMPS Configuration contains embedded database dependency %s:%s", dbArtifact.getGroupId(), dbArtifact.getArtifactId());
            return Optional.empty();
        }
        this.info("Neither Confluence WAR nor AMPS configuration contains %s:%s, adding extra container dependency %s", dbArtifact.getGroupId(), dbArtifact.getArtifactId(), dbArtifact);
        return Optional.of(dbArtifact);
    }

    private Optional<Set<ProductArtifact>> readBundledLibrariesMetadata(File warFile) {
        try {
            return this.warFileBundledLibrariesMetadataReader.readBundledLibrariesManifest(warFile);
        }
        catch (IOException e) {
            this.log.warn((CharSequence)"Failed to read WAR file to locate bundled library metadata", (Throwable)e);
            return Optional.empty();
        }
    }

    private static boolean containsGroupAndArtifactMatch(Collection<ProductArtifact> artifacts, ProductArtifact artifact) {
        return artifacts.stream().anyMatch(candidate -> Objects.equals(candidate.getGroupId(), artifact.getGroupId()) && Objects.equals(candidate.getArtifactId(), artifact.getArtifactId()));
    }

    private void info(String format, Object ... args) {
        this.log.info((CharSequence)String.format(format, args));
    }

    private <T> Stream<T> stream(Optional<T> optional) {
        return optional.map(Stream::of).orElseGet(Stream::empty);
    }

    @FunctionalInterface
    static interface WarFileBundledLibrariesManifestReader {
        public Optional<Set<ProductArtifact>> readBundledLibrariesManifest(File var1) throws IOException;
    }
}

