/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.PlatformVersion;
import com.atlassian.maven.plugins.amps.Product;
import com.google.common.collect.ImmutableMap;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;

public class AmpsDefaults {
    private static final AmpsDefaults DEFAULTS = new AmpsDefaults(AmpsDefaultsBuilder.access$000());
    private static final AmpsDefaults BEFORE_PLATFORM_8 = new AmpsDefaults(AmpsDefaultsBuilder.access$000().withDefaultEnableWebConsole(true));
    private static final AmpsDefaults PLATFORM_8 = new AmpsDefaults(AmpsDefaultsBuilder.access$000().withDefaultEnableWebConsole(false));
    private static final Map<PlatformVersion, AmpsDefaults> VERSIONS_MAP = ImmutableMap.of((Object)((Object)PlatformVersion.BEFORE_PLATFORM_8), (Object)BEFORE_PLATFORM_8, (Object)((Object)PlatformVersion.PLATFORM_8), (Object)PLATFORM_8);
    public final String defaultWebConsoleVersion;
    public final boolean defaultEnableWebConsole;
    public final String defaultDevToolboxVersion;
    public final String defaultAchooVersion;
    public final String defaultPdeVersion;
    public final String defaultQuickReloadVersion;
    public final String defaultPluginViewerVersion;
    public final String defaultLicenseBackdoorVersion;
    public final String defaultOsgiTestrunnerVersion;
    public final int defaultProductStartupTimeout;
    public final int defaultProductShutdownTimeout;
    public final String defaultServer = AmpsDefaults.resolveDefaultServer();
    public static final String DEFAULT_REST_API_BROWSER_VERSION = "3.2.8";
    private static final int DEFAULT_PRODUCT_STARTUP_TIMEOUT = 600000;
    private static final int DEFAULT_PRODUCT_SHUTDOWN_TIMEOUT = 600000;
    private static final String DEFAULT_WEB_CONSOLE_VERSION = "1.2.8";
    private static final boolean DEFAULT_ENABLE_WEB_CONSOLE = false;
    private static final String DEFAULT_DEV_TOOLBOX_VERSION = "3.2.1";
    private static final String DEFAULT_PDE_VERSION = "1.6.0";
    private static final String DEFAULT_ACHOO_VERSION = "1.4.1";
    private static final String DEFAULT_QUICK_RELOAD_VERSION = "6.2.0";
    private static final String DEFAULT_PLUGIN_VIEWER_VERSION = "2.2.0";
    private static final String DEFAULT_LICENSE_BACKDOOR_VERSION = "1.1.0";
    private static final String DEFAULT_OSGI_TESTRUNNER_VERSION = "2.0.16";

    private static String resolveDefaultServer() {
        String localHostName;
        try {
            localHostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            localHostName = "localhost";
        }
        return localHostName;
    }

    private AmpsDefaults(AmpsDefaultsBuilder builder) {
        this.defaultProductStartupTimeout = 600000;
        this.defaultProductShutdownTimeout = 600000;
        this.defaultWebConsoleVersion = DEFAULT_WEB_CONSOLE_VERSION;
        this.defaultDevToolboxVersion = DEFAULT_DEV_TOOLBOX_VERSION;
        this.defaultPdeVersion = DEFAULT_PDE_VERSION;
        this.defaultQuickReloadVersion = DEFAULT_QUICK_RELOAD_VERSION;
        this.defaultPluginViewerVersion = DEFAULT_PLUGIN_VIEWER_VERSION;
        this.defaultLicenseBackdoorVersion = DEFAULT_LICENSE_BACKDOOR_VERSION;
        this.defaultOsgiTestrunnerVersion = DEFAULT_OSGI_TESTRUNNER_VERSION;
        this.defaultAchooVersion = DEFAULT_ACHOO_VERSION;
        this.defaultEnableWebConsole = builder.defaultEnableWebConsole;
    }

    public static AmpsDefaults forProduct(Product product) {
        return PlatformVersion.fromProduct(product).map(version -> VERSIONS_MAP.getOrDefault(version, DEFAULTS)).orElse(DEFAULTS);
    }

    private static class AmpsDefaultsBuilder {
        private boolean defaultEnableWebConsole = false;

        private AmpsDefaultsBuilder() {
        }

        private static AmpsDefaultsBuilder builder() {
            return new AmpsDefaultsBuilder();
        }

        public AmpsDefaultsBuilder withDefaultEnableWebConsole(boolean enableWebConsole) {
            this.defaultEnableWebConsole = enableWebConsole;
            return this;
        }

        static /* synthetic */ AmpsDefaultsBuilder access$000() {
            return AmpsDefaultsBuilder.builder();
        }
    }
}

