/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.minifier.strategies.googleclosure;

import com.atlassian.maven.plugins.amps.code.Sources;
import com.atlassian.maven.plugins.amps.minifier.strategies.googleclosure.GoogleClosureOptionsHandler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.ImplicitNullabilityCheck;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.lint.CheckConstantCaseNames;
import com.google.javascript.jscomp.lint.CheckInterfaces;
import com.google.javascript.jscomp.lint.CheckJSDocStyle;
import com.google.javascript.jscomp.lint.CheckNullabilityModifiers;
import java.io.IOException;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;

public class GoogleClosureJsMinifier {
    protected static CompilerOptions getOptions(Map<String, String> closureOptions, Log log, boolean closureJsdocWarningsEnabled) {
        GoogleClosureOptionsHandler googleClosureOptionsHandler = new GoogleClosureOptionsHandler(log);
        googleClosureOptionsHandler.getCompilerOptions().setStrictModeInput(false);
        googleClosureOptionsHandler.getCompilerOptions().setLanguageIn(CompilerOptions.LanguageMode.STABLE);
        googleClosureOptionsHandler.getCompilerOptions().setLanguageOut(CompilerOptions.LanguageMode.ECMASCRIPT_2021);
        CompilationLevel.SIMPLE_OPTIMIZATIONS.setOptionsForCompilationLevel(googleClosureOptionsHandler.getCompilerOptions());
        if (closureOptions != null) {
            closureOptions.forEach(googleClosureOptionsHandler::setOption);
        }
        if (!closureJsdocWarningsEnabled) {
            googleClosureOptionsHandler.getCompilerOptions().setWarningLevel(DiagnosticGroups.NON_STANDARD_JSDOC, CheckLevel.OFF);
            googleClosureOptionsHandler.getCompilerOptions().setWarningLevel(DiagnosticGroups.MISPLACED_TYPE_ANNOTATION, CheckLevel.OFF);
            googleClosureOptionsHandler.getCompilerOptions().setWarningLevel(DiagnosticGroups.MISPLACED_MSG_ANNOTATION, CheckLevel.OFF);
            googleClosureOptionsHandler.getCompilerOptions().setWarningLevel(DiagnosticGroups.MISPLACED_SUPPRESS, CheckLevel.OFF);
            googleClosureOptionsHandler.getCompilerOptions().setWarningLevel(DiagnosticGroups.DEPRECATED_ANNOTATIONS, CheckLevel.OFF);
            googleClosureOptionsHandler.getCompilerOptions().setWarningLevel(DiagnosticGroups.JSDOC_MISSING_TYPE, CheckLevel.OFF);
            googleClosureOptionsHandler.getCompilerOptions().setWarningLevel(CheckJSDocStyle.LINT_DIAGNOSTICS, CheckLevel.OFF);
            googleClosureOptionsHandler.getCompilerOptions().setWarningLevel(DiagnosticGroup.forType((DiagnosticType)CheckNullabilityModifiers.MISSING_NULLABILITY_MODIFIER_JSDOC), CheckLevel.OFF);
            googleClosureOptionsHandler.getCompilerOptions().setWarningLevel(DiagnosticGroup.forType((DiagnosticType)CheckNullabilityModifiers.NULL_MISSING_NULLABILITY_MODIFIER_JSDOC), CheckLevel.OFF);
            googleClosureOptionsHandler.getCompilerOptions().setWarningLevel(DiagnosticGroup.forType((DiagnosticType)CheckNullabilityModifiers.REDUNDANT_NULLABILITY_MODIFIER_JSDOC), CheckLevel.OFF);
            googleClosureOptionsHandler.getCompilerOptions().setWarningLevel(DiagnosticGroup.forType((DiagnosticType)ImplicitNullabilityCheck.IMPLICITLY_NONNULL_JSDOC), CheckLevel.OFF);
            googleClosureOptionsHandler.getCompilerOptions().setWarningLevel(DiagnosticGroup.forType((DiagnosticType)ImplicitNullabilityCheck.IMPLICITLY_NULLABLE_JSDOC), CheckLevel.OFF);
            googleClosureOptionsHandler.getCompilerOptions().setWarningLevel(DiagnosticGroup.forType((DiagnosticType)CheckInterfaces.MISSING_JSDOC_IN_DECLARATION_STATEMENT), CheckLevel.OFF);
            googleClosureOptionsHandler.getCompilerOptions().setWarningLevel(DiagnosticGroup.forType((DiagnosticType)CheckConstantCaseNames.MISSING_CONST_PROPERTY), CheckLevel.OFF);
            DiagnosticGroup jscJSDocMissingBracesWarning = DiagnosticGroups.forName((String)"JSC_JSDOC_MISSING_BRACES_WARNING");
            if (jscJSDocMissingBracesWarning != null) {
                googleClosureOptionsHandler.getCompilerOptions().setWarningLevel(jscJSDocMissingBracesWarning, CheckLevel.OFF);
            }
        }
        return googleClosureOptionsHandler.getCompilerOptions();
    }

    public static Sources compile(String code, Map<String, String> closureOptions, Log log, boolean closureJsdocWarningsEnabled, String filenameForLogging) {
        Compiler compiler = new Compiler();
        CompilerOptions options = GoogleClosureJsMinifier.getOptions(closureOptions, log, closureJsdocWarningsEnabled);
        options.setSourceMapFormat(SourceMap.Format.V3);
        options.setSourceMapOutputPath("/dummy-file-path");
        SourceFile extern = SourceFile.fromCode((String)"externs.js", (String)"function alert(x) {}");
        SourceFile input = SourceFile.fromCode((String)filenameForLogging, (String)code);
        Result result = compiler.compile(extern, input, options);
        if (result.errors != null && !result.errors.isEmpty()) {
            throw new RuntimeException("There was a minification error");
        }
        String min = compiler.toSource();
        StringBuilder sourceMapStream = new StringBuilder();
        try {
            result.sourceMap.appendTo((Appendable)sourceMapStream, "/dummy-file-path");
        }
        catch (IOException e) {
            log.warn((CharSequence)"can't create source map", (Throwable)e);
        }
        return new Sources(min, sourceMapStream.toString());
    }
}

