/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.frontend.association.verification.utils;

import de.schlichtherle.truezip.file.TFile;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

public class ArtifactPathUtils {
    public static Set<String> getRelativePaths(Collection<TFile> files, TFile moduleRoot) {
        return files.stream().map(file -> ArtifactPathUtils.getRelativePath(file, moduleRoot)).collect(Collectors.toSet());
    }

    public static String getRelativePath(TFile file, TFile moduleRoot) {
        String separatorNormalizedPath = ArtifactPathUtils.normalizePathSeparators(file.getPath());
        Path normalizedPath = Paths.get(separatorNormalizedPath, new String[0]).normalize();
        return ArtifactPathUtils.normalizePathSeparators(Paths.get(moduleRoot.getPath(), new String[0]).relativize(normalizedPath).toString());
    }

    public static Set<String> normalizePathSeparators(Set<String> paths) {
        return paths.stream().map(ArtifactPathUtils::normalizePathSeparators).collect(Collectors.toSet());
    }

    public static String normalizePathSeparators(String path) {
        return path.replaceAll("\\\\", "/");
    }
}

