/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.frontend.association.mapping;

import com.atlassian.maven.plugins.amps.frontend.association.FeManifestAssociationConstants;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.model.FeManifestAssociationsConfiguration;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.model.FeOutputJsFileDeclaration;
import com.atlassian.maven.plugins.amps.frontend.association.mapping.utils.DirectoryHelper;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class FeManifestAssociationArbiter {
    private final DirectoryHelper directoryHelper;
    private final FeManifestAssociationsConfiguration configuration;
    private final Log logger;

    public FeManifestAssociationArbiter(DirectoryHelper directoryHelper, FeManifestAssociationsConfiguration configuration, Log logger) {
        this.directoryHelper = directoryHelper;
        this.configuration = configuration;
        this.logger = logger;
    }

    public void verifyOutput(Map<String, FeOutputJsFileDeclaration> outputJsFileDeclarations) throws MojoExecutionException {
        this.verifyAllDeclaredFilesExistInOutput(outputJsFileDeclarations);
        this.verifyAllOutputFilesAreDeclared(outputJsFileDeclarations);
    }

    @VisibleForTesting
    protected void verifyAllDeclaredFilesExistInOutput(Map<String, FeOutputJsFileDeclaration> outputJsFileDeclarations) throws MojoExecutionException {
        for (FeOutputJsFileDeclaration fileDeclaration : outputJsFileDeclarations.values()) {
            String filepath = fileDeclaration.getFilepath();
            String fileAbsolutePath = this.directoryHelper.getOutputFileAbsolutePath(filepath);
            File file = new File(fileAbsolutePath);
            if (file.exists()) continue;
            throw new MojoExecutionException(String.format("Declared file doesn't exist in build directory: %s", filepath));
        }
    }

    @VisibleForTesting
    protected void verifyAllOutputFilesAreDeclared(Map<String, FeOutputJsFileDeclaration> outputJsFileDeclarations) throws MojoExecutionException {
        String outputDirectoryPath = this.directoryHelper.getOutputDirectoryPath();
        File outputDirectory = new File(outputDirectoryPath);
        Collection files = FileUtils.listFiles((File)outputDirectory, (IOFileFilter)new RegexFileFilter(FeManifestAssociationConstants.JAVASCRIPT_FILE_REGEX), (IOFileFilter)DirectoryFileFilter.DIRECTORY);
        Set<String> filePaths = outputJsFileDeclarations.keySet();
        ArrayList<String> undeclaredFiles = new ArrayList<String>();
        for (File fileEntry : files) {
            String relativeToOutputDir = outputDirectory.toURI().relativize(fileEntry.toURI()).getPath();
            if (filePaths.contains(relativeToOutputDir)) continue;
            undeclaredFiles.add(relativeToOutputDir);
        }
        if (!undeclaredFiles.isEmpty()) {
            String prettyPrintFilePaths = String.join((CharSequence)"\n", undeclaredFiles);
            String message = String.format("Some files exist in output but have not been declared in any manifest association:\n%s", prettyPrintFilePaths);
            if (Boolean.TRUE.equals(this.configuration.getIgnoreSomeFilesNotDeclared())) {
                this.logger.warn((CharSequence)message);
            } else {
                throw new MojoExecutionException(message);
            }
        }
    }
}

