/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.artifact.Artifact;

public class ProductArtifact {
    private static final String DEFAULT_TYPE = "jar";
    private static final Map<String, String> MAVEN_TYPE_TO_CLASSIFIER = ProductArtifact.buildMavenTypeToClassifierMap();
    private String groupId;
    private String artifactId;
    private String version;
    private String type = "jar";
    private String classifier;
    private String path;

    private static Map<String, String> buildMavenTypeToClassifierMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("test-jar", "tests");
        map.put("java-source", "sources");
        map.put("javadoc", "javadoc");
        map.put("ejb-client", "ejb-client");
        return map;
    }

    public ProductArtifact() {
    }

    public ProductArtifact(String groupId, String artifactId) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.type = DEFAULT_TYPE;
    }

    public ProductArtifact(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.type = DEFAULT_TYPE;
    }

    public ProductArtifact(String groupId, String artifactId, String version, String type) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.type = type;
        this.classifier = MAVEN_TYPE_TO_CLASSIFIER.get(type);
    }

    public ProductArtifact(String groupId, String artifactId, String version, String type, String path) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.type = type;
        this.path = path;
        this.classifier = MAVEN_TYPE_TO_CLASSIFIER.get(type);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setClassifier(String qualifier) {
        this.classifier = qualifier;
    }

    public String getClassifier() {
        if (this.classifier == null && !DEFAULT_TYPE.equals(this.type)) {
            this.classifier = MAVEN_TYPE_TO_CLASSIFIER.get(this.type);
        }
        return this.classifier;
    }

    public String toString() {
        return this.groupId + ":" + this.artifactId + ":" + this.version + ":" + this.type;
    }

    public boolean isOverride(ProductArtifact other) {
        return other != null && Objects.equals(this.groupId, other.groupId) && Objects.equals(this.artifactId, other.artifactId) && Objects.equals(this.type, other.type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProductArtifact)) {
            return false;
        }
        ProductArtifact that = (ProductArtifact)o;
        if (!Objects.equals(this.groupId, that.groupId)) {
            return false;
        }
        if (!Objects.equals(this.artifactId, that.artifactId)) {
            return false;
        }
        if (!Objects.equals(this.version, that.version)) {
            return false;
        }
        return Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        int result = this.groupId != null ? this.groupId.hashCode() : 0;
        result = 31 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public static ProductArtifact fromArtifact(Artifact artifact) {
        return new ProductArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType());
    }

    public static Collection<String> getAllClassifiers() {
        return MAVEN_TYPE_TO_CLASSIFIER.values();
    }
}

