/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractAmpsMojo;
import com.atlassian.maven.plugins.amps.analytics.AnalyticsService;
import com.atlassian.maven.plugins.amps.analytics.event.AnalyticsEvent;
import com.atlassian.maven.plugins.amps.analytics.event.impl.AnalyticsEventFactory;
import com.atlassian.maven.plugins.amps.analytics.impl.GoogleAnalyticsService;
import com.atlassian.maven.plugins.amps.product.ProductHandler;
import com.atlassian.maven.plugins.amps.product.ProductHandlerFactory;
import com.atlassian.maven.plugins.amps.product.manager.WebAppManager;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.prefs.Preferences;
import javax.annotation.Nonnull;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.repository.RepositorySystem;

public abstract class AbstractProductAwareMojo
extends AbstractAmpsMojo {
    private static final String PREF_FIRSTRUN_PREFIX = "sdk-firstrun";
    private AnalyticsService analyticsService;
    @Component
    protected ArtifactResolver artifactResolver;
    @Component
    private ProjectBuilder projectBuilder;
    @Component
    protected RepositorySystem repositorySystem;
    @Component
    private WebAppManager webAppManager;
    @Parameter(property="product")
    private String product;
    @Parameter(property="instanceId")
    protected String instanceId;
    @Parameter(property="allow.google.tracking", defaultValue="true")
    protected boolean allowGoogleTracking;
    private final ConcurrentMap<String, ProductHandler> productHandlerCache = new ConcurrentHashMap<String, ProductHandler>();

    protected String getDefaultProductId() {
        String nameOfTheCurrentMavenPlugin = this.getPluginInformation().getId();
        if (ProductHandlerFactory.getIds().contains(nameOfTheCurrentMavenPlugin)) {
            return nameOfTheCurrentMavenPlugin;
        }
        return null;
    }

    @Nonnull
    protected final String getProductId() {
        if (this.product == null) {
            this.product = this.getDefaultProductId();
            if (this.product == null) {
                this.product = "refapp";
            }
        }
        return this.product;
    }

    @Nonnull
    private AnalyticsService getAnalyticsService() throws MojoExecutionException {
        if (this.analyticsService == null) {
            this.analyticsService = GoogleAnalyticsService.newGoogleAnalyticsService(this.getProductId(), this.getAmpsPluginVersion(), this.getPluginInformation().getVersion(), this.getLog());
            this.getLog().info((CharSequence)"Google Analytics Tracking is enabled to collect AMPS usage statistics.");
            this.getLog().info((CharSequence)"Although no personal information is sent, you may disable tracking by adding <allowGoogleTracking>false</allowGoogleTracking> to the AMPS plugin configuration in your pom.xml");
        }
        return this.analyticsService;
    }

    protected final void sendAnalyticsEvent(@Nonnull AnalyticsEvent event) throws MojoExecutionException {
        if (this.allowGoogleTracking) {
            this.getAnalyticsService().send(event);
        }
    }

    protected final void trackFirstRunIfNeeded() throws MojoExecutionException {
        boolean runningShellScript;
        boolean bl = runningShellScript = System.getenv("ATLAS_VERSION") != null;
        if (this.allowGoogleTracking && runningShellScript) {
            String firstRunKey = "sdk-firstrun-" + this.getAmpsPluginVersion();
            Preferences prefs = Preferences.userNodeForPackage(((Object)((Object)this)).getClass());
            String alreadyRan = prefs.get(firstRunKey, null);
            if (alreadyRan == null) {
                this.sendAnalyticsEvent(AnalyticsEventFactory.sdkFirstRun(this.getAmpsPluginVersion()));
                prefs.put(firstRunKey, "true");
            }
        }
    }

    protected ProductHandler getProductHandler(String productId) {
        return this.productHandlerCache.computeIfAbsent(productId, key -> ProductHandlerFactory.create(productId, this.getMavenContext(), this.getMavenGoals(), this.repositorySystem, this.projectBuilder, this.artifactResolver, this.webAppManager));
    }
}

