/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.osgi.test.rest;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrowableTypeAdapter
extends TypeAdapter<Throwable> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThrowableTypeAdapter.class);

    public Throwable read(JsonReader reader) throws IOException {
        String message = null;
        String type = null;
        Optional<StackTraceElement[]> stackTrace = Optional.empty();
        String serialized = null;
        reader.beginObject();
        block12: while (reader.hasNext()) {
            String name;
            switch (name = reader.nextName()) {
                case "type": {
                    type = reader.nextString();
                    continue block12;
                }
                case "message": {
                    message = reader.nextString();
                    continue block12;
                }
                case "stackTrace": {
                    stackTrace = Optional.of(this.readStackTraceElements(reader));
                    continue block12;
                }
                case "serialized": {
                    serialized = reader.nextString();
                    continue block12;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        Throwable t = this.buildThrowable(serialized, type, message);
        stackTrace.ifPresent(t::setStackTrace);
        return t;
    }

    Throwable buildThrowable(String serialized, String type, String message) {
        return Optional.ofNullable(serialized).map(this::deserializeThrowable).orElseGet(() -> this.constructTypedThrowable(type, message).orElseGet(() -> new Throwable(message)));
    }

    /*
     * Exception decompiling
     */
    private Throwable deserializeThrowable(String serialized) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Optional<Throwable> constructTypedThrowable(String type, String message) {
        if (type == null) {
            return Optional.empty();
        }
        try {
            Class<?> clazz = Class.forName(type);
            return Stream.of(clazz.getConstructors()).filter(constructor -> constructor.getParameterCount() > 0 && constructor.getParameterTypes()[0].equals(String.class)).map(c -> this.construct((Constructor<? extends Throwable>)c, message)).findFirst();
        }
        catch (Exception e) {
            LOGGER.warn("Failed to build an instance of {} with message {}", (Object)type, (Object)message);
            return Optional.empty();
        }
    }

    private Throwable construct(Constructor<? extends Throwable> constructor, String message) {
        Object[] params = new Object[constructor.getParameterCount()];
        params[0] = message;
        for (int i = 1; i < constructor.getParameterCount(); ++i) {
            params[i] = null;
        }
        try {
            return constructor.newInstance(params);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to build an instance of {} with message {}", new Object[]{constructor.getDeclaringClass().getName(), message, e});
            return null;
        }
    }

    private StackTraceElement[] readStackTraceElements(JsonReader reader) throws IOException {
        ArrayList<StackTraceElement> stackTraceElements = new ArrayList<StackTraceElement>();
        reader.beginArray();
        while (reader.hasNext()) {
            stackTraceElements.add(this.readStackTraceElement(reader));
        }
        reader.endArray();
        return stackTraceElements.toArray(new StackTraceElement[0]);
    }

    private StackTraceElement readStackTraceElement(JsonReader reader) throws IOException {
        String declaringClass = "";
        String methodName = "";
        String fileName = "";
        int lineNumber = -1;
        reader.beginObject();
        block12: while (reader.hasNext()) {
            String name;
            switch (name = reader.nextName()) {
                case "declaringClass": {
                    declaringClass = reader.nextString();
                    continue block12;
                }
                case "methodName": {
                    methodName = reader.nextString();
                    continue block12;
                }
                case "fileName": {
                    fileName = reader.nextString();
                    continue block12;
                }
                case "lineNumber": {
                    lineNumber = reader.nextInt();
                    continue block12;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        return new StackTraceElement(declaringClass, methodName, fileName, lineNumber);
    }

    private void writeStackTraceElements(JsonWriter out, StackTraceElement[] elements) throws IOException {
        if (elements != null && elements.length > 0) {
            out.name("stackTrace");
            out.beginArray();
            for (StackTraceElement element : elements) {
                this.writeStackTraceElement(out, element);
            }
            out.endArray();
        }
    }

    private void writeStackTraceElement(JsonWriter out, StackTraceElement stackTraceElement) throws IOException {
        out.beginObject();
        out.name("declaringClass");
        out.value(stackTraceElement.getClassName());
        out.name("methodName");
        out.value(stackTraceElement.getMethodName());
        out.name("fileName");
        out.value(stackTraceElement.getFileName());
        out.name("lineNumber");
        out.value((long)stackTraceElement.getLineNumber());
        out.endObject();
    }

    public void write(JsonWriter out, Throwable value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        try {
            out.beginObject();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(value);
            }
            out.name("serialized");
            out.value(new String(Base64.getEncoder().encode(baos.toByteArray())));
        }
        catch (IOException ioe) {
            LOGGER.warn("Failed to serialize throwable {}, falling back to json partial serialization", (Object)value, (Object)ioe);
        }
        out.name("type");
        out.value(value.getClass().getName());
        out.name("message");
        out.value(value.getMessage());
        this.writeStackTraceElements(out, value.getStackTrace());
        Throwable cause = value.getCause();
        if (cause != null) {
            out.name("cause");
            this.write(out, cause);
        }
        out.endObject();
    }
}

