/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.osgi.test;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.plugins.osgi.test.RestTestHeader;
import com.atlassian.plugins.osgi.test.RestTestHeaders;
import com.atlassian.plugins.osgi.test.rest.GsonFactory;
import com.atlassian.plugins.osgi.test.rest.TestResultDetailRepresentation;
import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wink.client.ClientConfig;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.Resource;
import org.apache.wink.client.RestClient;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runner.notification.StoppedByUserException;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlassianPluginsTestRunner
extends BlockJUnit4ClassRunner {
    static final String BASE_URL = "baseurl";
    private static final Logger LOGGER = LoggerFactory.getLogger(AtlassianPluginsTestRunner.class);

    static String getResourceUrl(Description description) {
        String baseUrl = System.getProperty(BASE_URL);
        if (AtlassianPluginsTestRunner.isBlank(baseUrl)) {
            throw new IllegalStateException(String.format("Missing base URL '%s'; is the '%s' system property set?", baseUrl, BASE_URL));
        }
        return baseUrl + "/rest/atlassiantestrunner/1.0/runtest/" + description.getClassName();
    }

    private static boolean isBlank(String string) {
        return string == null || string.trim().isEmpty();
    }

    public AtlassianPluginsTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    public void run(RunNotifier notifier) {
        EachTestNotifier testNotifier = new EachTestNotifier(notifier, this.getDescription());
        try {
            String[] packageParts = this.getTestClass().getJavaClass().getPackage().getName().split("\\.");
            if (null == packageParts || packageParts.length < 1 || !packageParts[0].equals("it")) {
                throw new Exception("the class [" + this.getTestClass().getJavaClass().getName() + "] is annotated with @RunWith(AtlassianPluginsTestRunner.class) but it is not in the 'it.' package.\nPlease move the class into the 'it.' package or remove the @RunWith annotation");
            }
            this.runViaRestCall(this.getDescription(), notifier);
        }
        catch (AssumptionViolatedException e) {
            testNotifier.fireTestIgnored();
        }
        catch (StoppedByUserException e) {
            throw e;
        }
        catch (Throwable e) {
            testNotifier.addFailure(e);
        }
    }

    private Map<String, String> getHeaders(Description description) {
        RestTestHeaders restTestHeaders;
        HashMap<String, String> headers = new HashMap<String, String>();
        RestTestHeader restTestHeader = (RestTestHeader)description.getAnnotation(RestTestHeader.class);
        if (restTestHeader != null) {
            headers.put(restTestHeader.name(), restTestHeader.value());
        }
        if ((restTestHeaders = (RestTestHeaders)description.getAnnotation(RestTestHeaders.class)) != null) {
            for (RestTestHeader header : restTestHeaders.value()) {
                headers.put(header.name(), header.value());
            }
        }
        return headers;
    }

    private void runViaRestCall(Description description, RunNotifier notifier) throws IOException {
        EachTestNotifier testNotifier;
        String resourceUrl = AtlassianPluginsTestRunner.getResourceUrl(description);
        ClientConfig config = new ClientConfig();
        config.readTimeout(1800000);
        RestClient client = new RestClient(config);
        Resource resource = client.resource(resourceUrl).accept(new String[]{"application/json"});
        this.getHeaders(description).forEach((x$0, xva$1) -> resource.header(x$0, new String[]{xva$1}));
        ClientResponse clientResponse = resource.get();
        if (clientResponse.getStatusCode() >= 300) {
            throw new IllegalStateException("Could not find resource for test [" + resourceUrl + "]. Status: " + clientResponse.getStatusCode() + " - " + clientResponse.getMessage());
        }
        String response = (String)clientResponse.getEntity(String.class);
        TestResultDetailRepresentation osgiResult = this.parseTestResultsFromJsonString(response);
        int totalCount = osgiResult.getFailedMethods().size() + osgiResult.getIgnoredMethods().size() + osgiResult.getPassedMethods().size();
        if (totalCount < 1) {
            Description desc = Description.createSuiteDescription((String)("No tests found in class [" + description.getClassName() + "]"), (Annotation[])new Annotation[0]);
            Failure failure = new Failure(desc, (Throwable)new Exception("No tests found in class [" + description.getClassName() + "]"));
            notifier.fireTestFailure(failure);
        }
        for (String string : osgiResult.getPassedMethods()) {
            testNotifier = new EachTestNotifier(notifier, Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)string));
            testNotifier.fireTestStarted();
            testNotifier.fireTestFinished();
        }
        for (String string : osgiResult.getIgnoredMethods()) {
            testNotifier = new EachTestNotifier(notifier, Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)string));
            testNotifier.fireTestIgnored();
        }
        for (Map.Entry entry : osgiResult.getFailedMethods().entrySet()) {
            String fMethodName = (String)entry.getKey();
            Failure f = (Failure)entry.getValue();
            EachTestNotifier testNotifier2 = new EachTestNotifier(notifier, Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)fMethodName));
            testNotifier2.addFailure(f.getException());
        }
    }

    protected void validateConstructor(List<Throwable> errors) {
    }

    @VisibleForTesting
    protected TestResultDetailRepresentation parseTestResultsFromJsonString(String rawResponse) throws IOException {
        Gson gson = GsonFactory.getGson();
        try {
            return (TestResultDetailRepresentation)gson.fromJson(rawResponse, TestResultDetailRepresentation.class);
        }
        catch (JsonIOException e) {
            LOGGER.info("Raw response: {}", (Object)rawResponse);
            throw new IOException("Failed to parse JSON test results received from REST API. See raw response in logs above", e);
        }
    }
}

