/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen.util;

import com.atlassian.plugins.codegen.modules.PluginModuleLocation;
import com.atlassian.plugins.codegen.util.Dom4jUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class PluginXmlHelper {
    public static final String PROJECT_RESOURCES_DIR = "src/main/resources";
    public static final String TEST_RESOURCES_DIR = "src/test/resources";
    public static final String PLUGIN_DESCRIPTOR_FILENAME = "atlassian-plugin.xml";
    public static final String PLUGIN_DESCRIPTOR_PATH = "src/main/resources/atlassian-plugin.xml";
    public static final String PLUGIN_DESC_ROOT_EL_NAME = "atlassian-plugin";
    public static final String PLUGIN_DESC_ROOT_EL_VER_ATTR = "pluginsVersion";
    public static final String PLUGIN_DESC_ROOT_EL_VER_ATTR_ALT = "plugins-version";
    public static final String PLUGIN_INFO_EL_NAME = "plugin-info";
    public static final String BUNDLE_INSTRUCTIONS_EL_NAME = "bundle-instructions";
    private final Document document;
    private final File xmlFile;
    private final PluginModuleLocation location;

    public static Optional<Element> findElementByTypeAndAttribute(Element parent, String type, String attributeName, String attributeValue) {
        List children = parent.elements(type);
        return children.stream().filter(Element.class::isInstance).map(Element.class::cast).filter(e -> attributeValue.equals(e.attributeValue(attributeName))).findFirst();
    }

    private static Document read(File xmlFile) throws DocumentException, IOException {
        SAXReader reader = Dom4jUtil.newSaxReader();
        reader.setMergeAdjacentText(true);
        return reader.read(xmlFile);
    }

    public PluginXmlHelper(PluginModuleLocation location) throws DocumentException, IOException {
        this(location, PLUGIN_DESCRIPTOR_FILENAME);
    }

    @VisibleForTesting
    PluginXmlHelper(PluginModuleLocation location, String descriptorName) throws DocumentException, IOException {
        this.location = location;
        this.xmlFile = new File(location.getResourcesDir(), descriptorName);
        this.document = PluginXmlHelper.read(this.xmlFile);
    }

    public PluginXmlHelper(File pluginXmlFile) throws IOException, DocumentException {
        this.location = null;
        this.xmlFile = pluginXmlFile;
        this.document = PluginXmlHelper.read(pluginXmlFile);
    }

    public Document getDocument() {
        return this.document;
    }

    public File getXmlFile() {
        return this.xmlFile;
    }

    private String getPluginKey() {
        String key = this.document.getRootElement().attributeValue("key");
        if (key == null) {
            throw new IllegalStateException("atlassian-plugin element does not have required attribute: key");
        }
        if (this.location == null) {
            if (key.contains("${")) {
                String message = String.format("cannot substitute placeholders in plugin key '%s' when plugin details are unknown", key);
                throw new UnsupportedOperationException(message);
            }
            return key;
        }
        return key.replace("${project.groupId}", this.location.getGroupId()).replace("${project.artifactId}", this.location.getArtifactId()).replace("${atlassian.plugin.key}", this.location.getDefaultPluginKey());
    }

    public String getDefaultI18nName() {
        return "i18n";
    }

    @Nonnull
    public String getDefaultI18nLocation() {
        List i18nNodes = this.document.selectNodes("//resource[@type='i18n']");
        return i18nNodes.stream().filter(Element.class::isInstance).map(Element.class::cast).findFirst().map(element -> element.attributeValue("location")).orElseGet(this::getPluginKey);
    }
}

