/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util.manifest;

import com.atlassian.maven.plugins.amps.util.manifest.ManifestDeserializer;
import com.atlassian.maven.plugins.amps.util.manifest.ParsedManifest;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ManifestSerializer {
    private static final int INDENT_SPACES = 4;

    public static String toPrettifiedString(ParsedManifest manifest) {
        StringBuilder prettified = new StringBuilder();
        for (Map.Entry<String, Object> entry : manifest.getManifestMap().entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            String prettifiedVal = (ManifestDeserializer.HDRS_PARAMABLE.contains(key) || key.equals("Bundle-ClassPath")) && value instanceof Map ? ManifestSerializer.prettifyParamable((Map)value) : " " + value.toString();
            prettified.append(key).append(":").append(prettifiedVal).append("\n");
        }
        return prettified.toString();
    }

    private static String prettifyParamable(Map<String, Object> paramable) {
        StringBuilder prettified = new StringBuilder();
        int entryCount = 0;
        int totalEntries = paramable.size();
        for (Map.Entry<String, Object> entry : paramable.entrySet()) {
            boolean isLastEntry;
            String packageName = entry.getKey();
            Object value = entry.getValue();
            boolean bl = isLastEntry = ++entryCount == totalEntries;
            if (value instanceof Map) {
                prettified.append(ManifestSerializer.prettifyPackageEntry(packageName, (Map)value));
            } else {
                prettified.append("\n").append(ManifestSerializer.spaces(4)).append(packageName);
            }
            if (isLastEntry) continue;
            prettified.append(",");
        }
        return prettified.toString();
    }

    private static String prettifyPackageEntry(String packageName, Map<String, Object> valueMap) {
        StringBuilder result = new StringBuilder();
        result.append("\n").append(ManifestSerializer.spaces(4)).append(packageName);
        boolean hasAttrs = valueMap.containsKey("attributes");
        boolean hasDirs = valueMap.containsKey("directives");
        if (hasAttrs || hasDirs) {
            result.append(";");
            if (hasAttrs) {
                result.append(ManifestSerializer.prettifyParams(valueMap.get("attributes"), "=", 2));
                if (hasDirs) {
                    result.append(";");
                }
            }
            if (hasDirs) {
                result.append(ManifestSerializer.prettifyParams(valueMap.get("directives"), ":=", 2));
            }
        }
        return result.toString();
    }

    private static String prettifyParams(Object params, String sep, int level) {
        if (params instanceof Map) {
            return ManifestSerializer.prettifyMap((Map)params, sep, level);
        }
        if (params instanceof List) {
            return ManifestSerializer.prettifyList((List)params, sep, level);
        }
        return params.toString();
    }

    private static String prettifyMap(Map<String, Object> paramsMap, String sep, int level) {
        StringBuilder prettified = new StringBuilder();
        String indent = ManifestSerializer.spaces(4 * level);
        int entryCount = 0;
        int totalEntries = paramsMap.size();
        for (Map.Entry<String, Object> entry : paramsMap.entrySet()) {
            boolean isLastEntry = ++entryCount == totalEntries;
            String key = entry.getKey();
            Object value = entry.getValue();
            prettified.append("\n").append(indent).append(key).append(sep);
            prettified.append(ManifestSerializer.formatParamValue(key, value, sep, level));
            if (isLastEntry) continue;
            prettified.append(";");
        }
        return prettified.toString();
    }

    private static String prettifyList(List<?> paramsList, String sep, int level) {
        StringBuilder prettified = new StringBuilder();
        String indent = ManifestSerializer.spaces(4 * level);
        int itemCount = 0;
        int totalItems = paramsList.size();
        for (Object value : paramsList) {
            boolean isLastItem = ++itemCount == totalItems;
            prettified.append("\n").append(indent).append(ManifestSerializer.prettifyParams(value, sep, level + 1));
            if (isLastItem) continue;
            prettified.append(",");
        }
        return prettified.toString();
    }

    private static String formatParamValue(String key, Object value, String sep, int level) {
        if (key.equals("uses") && value instanceof List) {
            return "\"" + ManifestSerializer.prettifyParams(value, sep, level + 1) + "\"";
        }
        return ManifestSerializer.prettifyParams(value, sep, level + 1);
    }

    private static String spaces(int count) {
        return StringUtils.repeat((String)" ", (int)count);
    }
}

