/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util.manifest;

import com.atlassian.maven.plugins.amps.util.manifest.ParsedManifest;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestDeserializer {
    private static final Logger log = LoggerFactory.getLogger(ManifestDeserializer.class);
    static final String SEP_HDR = ":";
    static final String DEL_PARAMABLE = ",";
    static final String DEL_PARAM = ";";
    static final String SEP_DIR = ":=";
    static final String SEP_ATTR = "=";
    static final String MARKER_DUP_PACKAGE = "~";
    static final String DIR_USES = "uses";
    static final String SEP_USES = ",";
    static final String HDR_BUNDLE_CLASSPATH = "Bundle-ClassPath";
    static final String HDR_VERSION = "Manifest-Version";
    static final String KEY_ATTRS = "attributes";
    static final String KEY_DIRS = "directives";
    static final List<String> HDRS_PARAMABLE = Arrays.asList("Conditional-Package", "Private-Package", "Require-Capability", "Import-Package", "DynamicImport-Package", "Export-Package");

    public static ParsedManifest parseManifestFromJar(Path jarPath) throws IOException {
        try (JarFile jar = ManifestDeserializer.openJarFile(jarPath);){
            ParsedManifest parsedManifest = ManifestDeserializer.parseManifest(ManifestDeserializer.getManifestInputStream(jar));
            return parsedManifest;
        }
    }

    public static ParsedManifest parseManifest(Path path) throws IOException {
        return ManifestDeserializer.parseManifest(Files.newInputStream(path, new OpenOption[0]));
    }

    public static ParsedManifest parseManifest(String rawContents) throws IOException {
        return ManifestDeserializer.parseManifest(new ByteArrayInputStream(rawContents.getBytes(StandardCharsets.UTF_8)));
    }

    public static ParsedManifest parseManifest(InputStream stream) throws IOException {
        String joined = ManifestDeserializer.joinManifest(stream);
        return new ParsedManifest(ManifestDeserializer.normaliseManifest(joined));
    }

    private static JarFile openJarFile(Path path) throws IOException {
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new NoSuchFileException(path + ": no such file");
        }
        try {
            return new JarFile(path.toFile());
        }
        catch (IOException e) {
            throw new IOException(path + ": not a valid JAR file", e);
        }
    }

    private static InputStream getManifestInputStream(JarFile jar) throws IOException {
        ZipEntry manifestEntry = jar.getEntry("META-INF/MANIFEST.MF");
        if (manifestEntry == null) {
            throw new IOException("No MANIFEST.MF found in JAR");
        }
        return jar.getInputStream(manifestEntry);
    }

    private static String joinManifest(InputStream is) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            String line;
            StringBuilder joined = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                joined.append(line).append('\n');
            }
            String string = joined.toString().replaceAll("\n +", "");
            return string;
        }
    }

    private static Map<String, Object> normaliseManifest(String buf) {
        LinkedHashMap<String, Object> normalised = new LinkedHashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String line : buf.split("\n")) {
            if ((line = line.trim()).isEmpty()) continue;
            if (line.contains(SEP_HDR)) {
                String[] parts = line.split(SEP_HDR, 2);
                String key = parts[0].trim();
                String value = parts.length > 1 ? parts[1].trim() : "";
                headers.put(key, value);
                continue;
            }
            log.error("Ignoring unreadable line: '{}'", (Object)line);
        }
        if (headers.containsKey(HDR_VERSION)) {
            normalised.put(HDR_VERSION, headers.get(HDR_VERSION));
        }
        ArrayList sortedKeys = new ArrayList(headers.keySet());
        Collections.sort(sortedKeys);
        for (String key : sortedKeys) {
            if (key.equals(HDR_VERSION)) continue;
            if (HDRS_PARAMABLE.contains(key)) {
                normalised.put(key, ManifestDeserializer.normaliseParamable((String)headers.get(key)));
                continue;
            }
            if (key.equals(HDR_BUNDLE_CLASSPATH)) {
                LinkedHashMap classpath = new LinkedHashMap();
                List<String> items = ManifestDeserializer.splitOnCommaNotQuoted((String)headers.get(key));
                Collections.sort(items);
                for (String item : items) {
                    classpath.put(item, new LinkedHashMap());
                }
                normalised.put(key, classpath);
                continue;
            }
            normalised.put(key, headers.get(key));
        }
        return normalised;
    }

    private static Map<String, Object> normaliseParamable(String paramable) {
        LinkedHashMap<String, Object> normalised = new LinkedHashMap<String, Object>();
        for (String splitParamable : ManifestDeserializer.splitOnCommaNotQuoted(paramable)) {
            String[] params = splitParamable.split(Pattern.quote(DEL_PARAM));
            String packageName = params[0].trim();
            HashMap<String, String> attributes = new HashMap<String, String>();
            HashMap<String, Object> directives = new HashMap<String, Object>();
            for (int i = 1; i < params.length; ++i) {
                String value;
                String key;
                String[] parts;
                String param = params[i];
                if (param.contains(SEP_DIR)) {
                    parts = param.split(Pattern.quote(SEP_DIR), 2);
                    key = parts[0].trim();
                    value = parts[1].trim();
                    if (key.equals(DIR_USES)) {
                        String cleanValue = value.replaceAll("^\"|\"$", "").trim();
                        ArrayList<String> uses = new ArrayList<String>(Arrays.asList(cleanValue.split(",")));
                        Collections.sort(uses);
                        directives.put(key, uses);
                        continue;
                    }
                    directives.put(key, value);
                    continue;
                }
                if (!param.contains(SEP_ATTR)) continue;
                parts = param.split(Pattern.quote(SEP_ATTR), 2);
                key = parts[0].trim();
                value = parts[1].trim();
                attributes.put(key, value);
            }
            while (normalised.containsKey(packageName)) {
                packageName = packageName + MARKER_DUP_PACKAGE;
            }
            LinkedHashMap packageData = new LinkedHashMap();
            if (!attributes.isEmpty()) {
                TreeMap sortedAttrs = new TreeMap(attributes);
                packageData.put(KEY_ATTRS, sortedAttrs);
            }
            if (!directives.isEmpty()) {
                TreeMap sortedDirs = new TreeMap(directives);
                packageData.put(KEY_DIRS, sortedDirs);
            }
            normalised.put(packageName, packageData);
        }
        return normalised;
    }

    private static List<String> splitOnCommaNotQuoted(String toSplit) {
        ArrayList<String> split = new ArrayList<String>();
        StringBuilder line = new StringBuilder();
        boolean inside = false;
        for (char c : toSplit.trim().toCharArray()) {
            if (c == '\"') {
                boolean bl = inside = !inside;
            }
            if (c == ",".charAt(0) && !inside) {
                split.add(line.toString());
                line = new StringBuilder();
                continue;
            }
            line.append(c);
        }
        split.add(line.toString());
        return split;
    }
}

