/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util;

import com.atlassian.maven.plugins.amps.Node;
import com.atlassian.maven.plugins.amps.Product;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;

public final class DebugUtils {
    public static void setNodeDebugPorts(List<Product> products, int defaultPort) throws MojoExecutionException {
        int portOffset = 0;
        LinkedHashMap<Integer, List<String>> nodeIdsByDebugPort = new LinkedHashMap<Integer, List<String>>();
        for (Product product : products) {
            List<Node> nodes = product.getNodes();
            for (int nodeIndex = 0; nodeIndex < nodes.size(); ++nodeIndex) {
                Node node = nodes.get(nodeIndex);
                portOffset = DebugUtils.setDebugPort(node, defaultPort, portOffset);
                int debugPort = node.getJvmDebugPort();
                List nodeIds = nodeIdsByDebugPort.computeIfAbsent(debugPort, k -> new ArrayList());
                nodeIds.add(product.getInstanceId() + " node " + nodeIndex);
            }
        }
        DebugUtils.checkForPortConflicts(nodeIdsByDebugPort);
    }

    private static void checkForPortConflicts(Map<Integer, List<String>> nodeIdsByDebugPort) throws MojoExecutionException {
        String error = nodeIdsByDebugPort.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(entry -> String.format("Debug port %d is used by these nodes: %s", entry.getKey(), entry.getValue())).collect(Collectors.joining("; "));
        if (StringUtils.isNotBlank((CharSequence)error)) {
            throw new MojoExecutionException(error);
        }
    }

    private static int setDebugPort(Node node, int defaultPort, int portOffset) {
        if (node.getJvmDebugPort() == 0) {
            node.setJvmDebugPort(defaultPort + portOffset);
            return portOffset + 1;
        }
        return portOffset;
    }

    public static Map<String, String> getDebugPortProperties(Collection<Product> products) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        DebugUtils.putFirstNodeDebugPortProperty(products, properties);
        DebugUtils.putInstanceSpecificProperties(products, properties);
        return properties;
    }

    private static void putFirstNodeDebugPortProperty(Collection<Product> products, Map<String, String> properties) {
        products.stream().flatMap(product -> product.getNodes().stream()).findFirst().ifPresent(node -> {
            String debugPort = String.valueOf(node.getJvmDebugPort());
            properties.put("debug.port", debugPort);
        });
    }

    private static void putInstanceSpecificProperties(Collection<Product> products, Map<String, String> properties) {
        for (Product product : products) {
            List<Node> nodes = product.getNodes();
            for (int i = 0; i < nodes.size(); ++i) {
                Node node = nodes.get(i);
                String debugPort = String.valueOf(node.getJvmDebugPort());
                properties.put("debug." + product.getInstanceId() + ".port." + i, debugPort);
                if (i != 0) continue;
                properties.put("debug." + product.getInstanceId() + ".port", debugPort);
            }
        }
    }

    private DebugUtils() {
    }
}

