/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;

public class ArtifactListParser {
    private ArtifactListParser() {
    }

    public static List<String> parse(String list) throws IllegalArgumentException {
        String[] lines;
        ArrayList<String> artifacts = new ArrayList<String>();
        if (list == null || list.trim().isEmpty()) {
            return artifacts;
        }
        for (String line : lines = list.split("[\\r\\n]+")) {
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            ArtifactListParser.validateArtifactFormat(line);
            artifacts.add(line);
        }
        return artifacts;
    }

    private static void validateArtifactFormat(String artifact) throws IllegalArgumentException {
        String[] parts = artifact.split(":");
        if (parts.length > 6) {
            throw new IllegalArgumentException("Invalid artifact format: " + artifact);
        }
        if (parts.length >= 3) {
            String version = parts[2];
            try {
                VersionRange.createFromVersionSpec((String)version);
            }
            catch (InvalidVersionSpecificationException e) {
                throw new IllegalArgumentException("Invalid artifact version range in: " + artifact);
            }
        }
    }
}

