/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.transform.executor.xmltojava;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.commons.text.StringSubstitutor;

public class TemplateUtil {
    public static void writeTemplateToPath(Path writePath, String template, Map<String, String> params) throws IOException {
        Files.write(writePath, TemplateUtil.getProcessedTemplate(template, params).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public static String getProcessedTemplate(String template, Map<String, String> params) throws IOException {
        return new StringSubstitutor(params).replace(TemplateUtil.readResourceAsString(template));
    }

    static String readResourceAsString(String resourcePath) throws IOException {
        try (InputStream inputStream = TemplateUtil.class.getResourceAsStream(resourcePath);){
            String string = IOUtils.toString((InputStream)Objects.requireNonNull(inputStream, String.format("Resource does not exist: %s", resourcePath)), (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }
}

