/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.transform.executor.xmltojava;

import com.atlassian.maven.plugins.amps.product.common.XMLDocumentHandler;
import com.atlassian.maven.plugins.amps.transform.executor.xmltojava.GenerateJavaUtil;
import com.atlassian.maven.plugins.amps.transform.executor.xmltojava.IndividualConverter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.QName;

class ModuleTypesConverter
implements IndividualConverter {
    static final String XML_FILENAME = "atlassian-plugins-module-types.xml";
    static final String MODULE_FACTORY_CLASS = "com.atlassian.plugin.module.ModuleFactory";
    private static final String MODULE_TYPE_BEANS_JAVA = "ModuleTypeBeans.java";
    private static final String MODULE_TYPE_BEANS_TEMPLATE = "ModuleTypeBeans.sub";
    private static final String MODULE_TYPE_ENTRY_TEMPLATE = "ModuleTypeEntry.sub";
    private static final String SINGLE_MODULE_DESCRIPTOR_FACTORY_CLASS = "com.atlassian.plugin.osgi.external.SingleModuleDescriptorFactory";

    ModuleTypesConverter() {
    }

    @Override
    public String supportedXmlFilename() {
        return XML_FILENAME;
    }

    @Override
    public List<Path> convert(Path xmlPath, Path destDir) throws IOException {
        Document doc = XMLDocumentHandler.parse(xmlPath.toFile());
        Element root = doc.getRootElement();
        List beans = root.elements(new QName("bean", BEANS_NS));
        if (beans.isEmpty()) {
            return ImmutableList.of();
        }
        LinkedHashSet<Map<String, String>> allBeanParams = new LinkedHashSet<Map<String, String>>();
        for (Element bean : beans) {
            String beanClass = bean.attributeValue("class");
            if (!SINGLE_MODULE_DESCRIPTOR_FACTORY_CLASS.equals(beanClass)) continue;
            List constructorArgs = bean.elements(new QName("constructor-arg", BEANS_NS));
            String moduleKey = null;
            String qualifiedClassName = null;
            for (Element constructorArg : constructorArgs) {
                Element valueElement;
                String index = constructorArg.attributeValue("index");
                if ("1".equals(index)) {
                    valueElement = constructorArg.element(new QName("value", BEANS_NS));
                    if (valueElement == null) continue;
                    moduleKey = valueElement.getTextTrim();
                    continue;
                }
                if (!"2".equals(index) || (valueElement = constructorArg.element(new QName("value", BEANS_NS))) == null) continue;
                qualifiedClassName = valueElement.getTextTrim();
            }
            if (moduleKey == null || qualifiedClassName == null) continue;
            ImmutableMap beanParams = ImmutableMap.of((Object)"beanName", (Object)GenerateJavaUtil.getDefaultBeanName(qualifiedClassName), (Object)"qualifiedClassName", qualifiedClassName, (Object)"moduleKey", moduleKey);
            allBeanParams.add((Map<String, String>)beanParams);
        }
        if (allBeanParams.isEmpty()) {
            return ImmutableList.of();
        }
        Path outputPath = destDir.resolve(MODULE_TYPE_BEANS_JAVA);
        this.generateModuleTypeBeansJavaFile(outputPath, allBeanParams);
        return ImmutableList.of((Object)outputPath);
    }

    private void generateModuleTypeBeansJavaFile(Path outputPath, Set<Map<String, String>> allBeanParams) throws IOException {
        GenerateJavaUtil.generateJavaFile(outputPath, allBeanParams, MODULE_TYPE_ENTRY_TEMPLATE, MODULE_TYPE_BEANS_TEMPLATE);
    }
}

