/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.transform.executor.xmltojava;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class JavaSourcePathUtil {
    public static Path findBasePackage(Path srcPath) throws IOException {
        if (!Files.isDirectory(srcPath, new LinkOption[0])) {
            throw new IllegalArgumentException(srcPath + " is not a directory");
        }
        Path current = srcPath;
        List<Path> packages;
        while ((packages = JavaSourcePathUtil.listPackageDirectories(current)).size() == 1 && !JavaSourcePathUtil.hasNonHiddenFile(current)) {
            current = packages.get(0);
        }
        return current;
    }

    private static boolean hasNonHiddenFile(Path directory) throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory);){
            for (Path path : stream) {
                if (!Files.isRegularFile(path, new LinkOption[0]) || path.getFileName().toString().startsWith(".")) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private static List<Path> listPackageDirectories(Path directory) throws IOException {
        ArrayList<Path> packageDirs = new ArrayList<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory);){
            for (Path path : stream) {
                if (!Files.isDirectory(path, new LinkOption[0]) || path.getFileName().toString().startsWith(".")) continue;
                packageDirs.add(path);
            }
        }
        return packageDirs;
    }

    public static String getQualifiedPackageFromPath(Path packagePath) {
        if (packagePath.getFileName().toString().contains(".")) {
            packagePath = packagePath.getParent();
        }
        Path normalizedPackagePath = packagePath.normalize().toAbsolutePath();
        Path srcMainJava = Paths.get("src", "main", "java");
        Path srcTestJava = Paths.get("src", "test", "java");
        for (Path current = normalizedPackagePath; current != null; current = current.getParent()) {
            if (!current.endsWith(srcMainJava) && !current.endsWith(srcTestJava)) continue;
            Path relativePath = current.relativize(normalizedPackagePath);
            return relativePath.toString().replace(FileSystems.getDefault().getSeparator(), ".");
        }
        throw new IllegalStateException(packagePath + " is not within a source directory");
    }

    public static String getQualifiedNameFromJavaFilePath(Path javaFilePath) {
        if (!javaFilePath.getFileName().toString().endsWith(".java")) {
            throw new IllegalArgumentException(javaFilePath + " is not a Java file");
        }
        String qualifiedPackage = JavaSourcePathUtil.getQualifiedPackageFromPath(javaFilePath);
        String className = javaFilePath.getFileName().toString().replaceFirst("\\.java$", "");
        return qualifiedPackage + "." + className;
    }

    public static String getSimpleClassNameFromJavaFilePath(Path javaFilePath) {
        if (!javaFilePath.getFileName().toString().endsWith(".java")) {
            throw new IllegalArgumentException(javaFilePath + " is not a Java file");
        }
        return javaFilePath.getFileName().toString().replaceFirst("\\.java$", "");
    }

    public static boolean isDirectoryEmpty(Path directoryPath) throws IOException {
        if (Files.exists(directoryPath, new LinkOption[0])) {
            if (Files.isRegularFile(directoryPath, new LinkOption[0])) {
                return false;
            }
            try (Stream<Path> stream = Files.list(directoryPath);){
                if (stream.findAny().isPresent()) {
                    boolean bl = false;
                    return bl;
                }
            }
        }
        return true;
    }
}

