/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.transform.executor.xmltojava;

import com.atlassian.maven.plugins.amps.product.common.XMLDocumentHandler;
import com.atlassian.maven.plugins.amps.transform.executor.xmltojava.GenerateJavaUtil;
import com.atlassian.maven.plugins.amps.transform.executor.xmltojava.IndividualConverter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

class HostComponentsConverter
implements IndividualConverter {
    static final String XML_FILENAME = "atlassian-plugins-host-components.xml";
    private static final String LAZY_IMPORT_BEANS_JAVA = "LazyImportBeans.java";
    private static final String LAZY_IMPORT_BEANS_TEMPLATE = "LazyImportBeans.sub";
    private static final String LAZY_IMPORT_ENTRY_TEMPLATE = "LazyImportEntry.sub";

    HostComponentsConverter() {
    }

    @Override
    public String supportedXmlFilename() {
        return XML_FILENAME;
    }

    @Override
    public List<Path> convert(Path xmlPath, Path destDir) throws IOException {
        Document doc = XMLDocumentHandler.parse(xmlPath.toFile());
        Element root = doc.getRootElement();
        List beans = root.elements(new QName("bean", BEANS_NS));
        if (beans.isEmpty()) {
            return ImmutableList.of();
        }
        LinkedHashSet<Map<String, String>> allBeanParams = new LinkedHashSet<Map<String, String>>();
        LinkedHashSet<String> additionalImports = new LinkedHashSet<String>();
        for (Element bean : beans) {
            List qualifiedInterfaces;
            List values;
            Element listElement;
            String beanName = bean.attributeValue("id");
            Element interfacesElement = HostComponentsConverter.findPropertyByName(bean, "interfaces", BEANS_NS);
            if (interfacesElement == null || (listElement = interfacesElement.element(new QName("list", BEANS_NS))) == null || (values = listElement.elements(new QName("value", BEANS_NS))).isEmpty() || "com.atlassian.plugin.module.ModuleFactory".equals((qualifiedInterfaces = values.stream().map(Element::getTextTrim).collect(Collectors.toList())).get(0)) && qualifiedInterfaces.size() == 1 && Files.exists(xmlPath.getParent().resolve("atlassian-plugins-module-types.xml"), new LinkOption[0])) continue;
            String interfacesAsString = qualifiedInterfaces.stream().map(GenerateJavaUtil::getSimpleClassName).map(name -> name + ".class").collect(Collectors.joining(", "));
            ImmutableMap beanParams = ImmutableMap.of((Object)"beanName", (Object)beanName, (Object)"interfacesAsString", (Object)interfacesAsString);
            allBeanParams.add((Map<String, String>)beanParams);
            additionalImports.addAll(qualifiedInterfaces);
        }
        if (allBeanParams.isEmpty()) {
            return ImmutableList.of();
        }
        Path outputPath = destDir.resolve(LAZY_IMPORT_BEANS_JAVA);
        HostComponentsConverter.generateLazyImportsJavaFile(outputPath, allBeanParams, additionalImports);
        return ImmutableList.of((Object)outputPath);
    }

    private static Element findPropertyByName(Element bean, String propertyName, Namespace beansNs) {
        return bean.elements(new QName("property", beansNs)).stream().filter(property -> propertyName.equals(property.attributeValue("name"))).findFirst().orElse(null);
    }

    private static void generateLazyImportsJavaFile(Path outputPath, Set<Map<String, String>> allBeanParams, Collection<String> additionalImports) throws IOException {
        GenerateJavaUtil.generateJavaFile(outputPath, allBeanParams, LAZY_IMPORT_ENTRY_TEMPLATE, LAZY_IMPORT_BEANS_TEMPLATE, additionalImports);
    }
}

