/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.transform.executor.xmltojava;

import com.atlassian.maven.plugins.amps.product.common.XMLDocumentHandler;
import com.atlassian.maven.plugins.amps.transform.executor.xmltojava.GenerateJavaUtil;
import com.atlassian.maven.plugins.amps.transform.executor.xmltojava.IndividualConverter;
import com.atlassian.maven.plugins.amps.transform.executor.xmltojava.JavaSourcePathUtil;
import com.atlassian.maven.plugins.amps.transform.executor.xmltojava.TemplateUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.QName;

class ComponentsConverter
implements IndividualConverter {
    static final String XML_FILENAME = "atlassian-plugins-components.xml";
    private static final String PLUGIN_BEANS_JAVA = "PluginBeans.java";
    private static final String PLUGIN_BEANS_TEMPLATE = "PluginBeans.sub";
    private static final String EXPORT_BEANS_JAVA = "ExportBeans.java";
    private static final String EXPORT_BEANS_TEMPLATE = "ExportBeans.sub";
    private static final String EXPORT_ENTRY_TEMPLATE = "ExportEntry.sub";

    ComponentsConverter() {
    }

    @Override
    public String supportedXmlFilename() {
        return XML_FILENAME;
    }

    @Override
    public List<Path> convert(Path xmlPath, Path destDir) throws IOException {
        List services;
        Set<ServiceInfo> serviceInfos;
        Document doc = XMLDocumentHandler.parse(xmlPath.toFile());
        Element root = doc.getRootElement();
        List beans = root.elements(new QName("bean", BEANS_NS));
        Map<String, String> beanNameToClass = this.createBeanNameToClassMap(beans);
        ArrayList<Path> generatedFiles = new ArrayList<Path>();
        if (!beans.isEmpty()) {
            Path pluginBeansPath = destDir.resolve(PLUGIN_BEANS_JAVA);
            this.generatePluginBeansJavaFile(pluginBeansPath, beanNameToClass);
            generatedFiles.add(pluginBeansPath);
        }
        if (!(serviceInfos = this.extractServiceInfo(services = root.elements(new QName("service", OSGI_NS)), beanNameToClass)).isEmpty()) {
            Path exportBeansPath = destDir.resolve(EXPORT_BEANS_JAVA);
            this.generateExportBeansJavaFile(exportBeansPath, serviceInfos);
            generatedFiles.add(exportBeansPath);
        }
        return ImmutableList.copyOf(generatedFiles);
    }

    private Map<String, String> createBeanNameToClassMap(List<Element> beans) {
        LinkedHashMap<String, String> beanNameToClass = new LinkedHashMap<String, String>();
        for (Element bean : beans) {
            String beanName = bean.attributeValue("id");
            String className = bean.attributeValue("class");
            if (beanName == null || className == null) continue;
            beanNameToClass.put(beanName, className);
        }
        return Collections.unmodifiableMap(beanNameToClass);
    }

    private void generatePluginBeansJavaFile(Path outputPath, Map<String, String> beanNameToClass) throws IOException {
        String packageName = JavaSourcePathUtil.getQualifiedPackageFromPath(outputPath);
        String importsSection = GenerateJavaUtil.getImportsFromClassNames(beanNameToClass.values());
        String classNamesAsString = GenerateJavaUtil.getSpringConfigImportsFromClassNames(beanNameToClass.values().stream().map(GenerateJavaUtil::getSimpleClassName).collect(Collectors.toList()));
        ImmutableMap params = ImmutableMap.of((Object)"packageName", (Object)packageName, (Object)"imports", (Object)importsSection, (Object)"classNamesAsString", (Object)classNamesAsString);
        TemplateUtil.writeTemplateToPath(outputPath, PLUGIN_BEANS_TEMPLATE, (Map<String, String>)params);
    }

    private Set<ServiceInfo> extractServiceInfo(List<Element> services, Map<String, String> beanNameToClass) {
        LinkedHashSet<ServiceInfo> serviceMap = new LinkedHashSet<ServiceInfo>();
        for (Element service : services) {
            List values;
            Element interfacesElement;
            String className;
            String beanName = service.attributeValue("ref");
            if (beanName == null || (className = beanNameToClass.get(beanName)) == null || (interfacesElement = service.element(new QName("interfaces", OSGI_NS))) == null || (values = interfacesElement.elements(new QName("value", BEANS_NS))).isEmpty()) continue;
            ArrayList<String> interfaces = new ArrayList<String>();
            for (Element value : values) {
                String interfaceName = value.getTextTrim();
                if (interfaceName == null || interfaceName.isEmpty()) continue;
                interfaces.add(interfaceName);
            }
            if (interfaces.isEmpty()) continue;
            serviceMap.add(new ServiceInfo(GenerateJavaUtil.getDefaultBeanName(className), className, interfaces));
        }
        return serviceMap;
    }

    private void generateExportBeansJavaFile(Path outputPath, Set<ServiceInfo> serviceMap) throws IOException {
        LinkedHashSet<Map<String, String>> beanParams = new LinkedHashSet<Map<String, String>>();
        LinkedHashSet<String> additionalImports = new LinkedHashSet<String>();
        for (ServiceInfo serviceInfo : serviceMap) {
            String interfacesAsString = serviceInfo.interfaces.stream().map(GenerateJavaUtil::getSimpleClassName).map(name -> name + ".class").collect(Collectors.joining(", "));
            beanParams.add((Map<String, String>)ImmutableMap.of((Object)"beanName", (Object)serviceInfo.beanName, (Object)"qualifiedClassName", (Object)serviceInfo.className, (Object)"interfacesAsString", (Object)interfacesAsString));
            additionalImports.addAll(serviceInfo.interfaces);
        }
        GenerateJavaUtil.generateJavaFile(outputPath, beanParams, EXPORT_ENTRY_TEMPLATE, EXPORT_BEANS_TEMPLATE, additionalImports);
    }

    private static class ServiceInfo {
        final String beanName;
        final String className;
        final List<String> interfaces;

        ServiceInfo(String beanName, String className, List<String> interfaces) {
            this.beanName = beanName;
            this.className = className;
            this.interfaces = interfaces;
        }
    }
}

