/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.transform.executor.xmltojava;

import com.atlassian.maven.plugins.amps.product.common.XMLDocumentHandler;
import com.atlassian.maven.plugins.amps.transform.executor.xmltojava.GenerateJavaUtil;
import com.atlassian.maven.plugins.amps.transform.executor.xmltojava.IndividualConverter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.QName;

class ComponentImportsConverter
implements IndividualConverter {
    static final String XML_FILENAME = "atlassian-plugins-component-imports.xml";
    private static final String IMPORT_BEANS_JAVA = "ImportBeans.java";
    private static final String IMPORT_BEANS_TEMPLATE = "ImportBeans.sub";
    private static final String IMPORT_ENTRY_TEMPLATE = "ImportEntry.sub";
    private static final String IMPORT_OPT_CLASSNAME = "com.atlassian.plugins.osgi.javaconfig.ImportOptions";
    private static final String IMPORT_FILTER_STR_TPLT = ", ImportOptions.defaultOptions().withFilter(\"%s\")";

    ComponentImportsConverter() {
    }

    @Override
    public String supportedXmlFilename() {
        return XML_FILENAME;
    }

    @Override
    public List<Path> convert(Path xmlPath, Path destDir) throws IOException {
        Document doc = XMLDocumentHandler.parse(xmlPath.toFile());
        Element root = doc.getRootElement();
        List references = root.elements(new QName("reference", OSGI_NS));
        if (references.isEmpty()) {
            return ImmutableList.of();
        }
        LinkedHashSet<Map<String, String>> allBeanParams = new LinkedHashSet<Map<String, String>>();
        LinkedHashSet<String> additionalImports = new LinkedHashSet<String>();
        for (Element reference : references) {
            String className;
            List values;
            String beanName = reference.attributeValue("id");
            String filter = reference.attributeValue("filter");
            boolean isFilter = StringUtils.isNotEmpty((CharSequence)filter);
            Element interfacesElement = reference.element(new QName("interfaces", OSGI_NS));
            if (interfacesElement == null || (values = interfacesElement.elements(new QName("value", BEANS_NS))).isEmpty() || "com.atlassian.plugin.module.ModuleFactory".equals(className = ((Element)values.get(0)).getTextTrim()) && Files.exists(xmlPath.getParent().resolve("atlassian-plugins-module-types.xml"), new LinkOption[0])) continue;
            if (isFilter) {
                additionalImports.add(IMPORT_OPT_CLASSNAME);
            }
            ImmutableMap beanParams = ImmutableMap.of((Object)"beanName", (Object)beanName, (Object)"qualifiedClassName", (Object)className, (Object)"additionalParamsAsString", (Object)(isFilter ? String.format(IMPORT_FILTER_STR_TPLT, filter) : ""));
            allBeanParams.add((Map<String, String>)beanParams);
        }
        if (allBeanParams.isEmpty()) {
            return ImmutableList.of();
        }
        Path outputPath = destDir.resolve(IMPORT_BEANS_JAVA);
        this.generateImportBeansJavaFile(outputPath, allBeanParams, additionalImports);
        return ImmutableList.of((Object)outputPath);
    }

    private void generateImportBeansJavaFile(Path outputPath, Set<Map<String, String>> allBeanParams, Set<String> additionalImports) throws IOException {
        GenerateJavaUtil.generateJavaFile(outputPath, allBeanParams, IMPORT_ENTRY_TEMPLATE, IMPORT_BEANS_TEMPLATE, additionalImports);
    }
}

